<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVideosByIdsResponse StructType
 * @subpackage Structs
 */
class GetVideosByIdsResponse extends AbstractStructBase
{
    /**
     * The Videos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfVideo
     */
    public $Videos;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetVideosByIdsResponse
     * @uses GetVideosByIdsResponse::setVideos()
     * @uses GetVideosByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfVideo $videos
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfVideo $videos = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setVideos($videos)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get Videos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfVideo|null
     */
    public function getVideos()
    {
        return isset($this->Videos) ? $this->Videos : null;
    }
    /**
     * Set Videos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfVideo $videos
     * @return \StructType\GetVideosByIdsResponse
     */
    public function setVideos(\ArrayType\ArrayOfVideo $videos = null)
    {
        if (is_null($videos) || (is_array($videos) && empty($videos))) {
            unset($this->Videos);
        } else {
            $this->Videos = $videos;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetVideosByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
