<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVideosByIdsRequest StructType
 * @subpackage Structs
 */
class GetVideosByIdsRequest extends AbstractStructBase
{
    /**
     * The VideoIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $VideoIds;
    /**
     * The PageInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Paging
     */
    public $PageInfo;
    /**
     * Constructor method for GetVideosByIdsRequest
     * @uses GetVideosByIdsRequest::setVideoIds()
     * @uses GetVideosByIdsRequest::setPageInfo()
     * @param \ArrayType\ArrayOflong $videoIds
     * @param \StructType\Paging $pageInfo
     */
    public function __construct(\ArrayType\ArrayOflong $videoIds = null, \StructType\Paging $pageInfo = null)
    {
        $this
            ->setVideoIds($videoIds)
            ->setPageInfo($pageInfo);
    }
    /**
     * Get VideoIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getVideoIds()
    {
        return isset($this->VideoIds) ? $this->VideoIds : null;
    }
    /**
     * Set VideoIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $videoIds
     * @return \StructType\GetVideosByIdsRequest
     */
    public function setVideoIds(\ArrayType\ArrayOflong $videoIds = null)
    {
        if (is_null($videoIds) || (is_array($videoIds) && empty($videoIds))) {
            unset($this->VideoIds);
        } else {
            $this->VideoIds = $videoIds;
        }
        return $this;
    }
    /**
     * Get PageInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Paging|null
     */
    public function getPageInfo()
    {
        return isset($this->PageInfo) ? $this->PageInfo : null;
    }
    /**
     * Set PageInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Paging $pageInfo
     * @return \StructType\GetVideosByIdsRequest
     */
    public function setPageInfo(\StructType\Paging $pageInfo = null)
    {
        if (is_null($pageInfo) || (is_array($pageInfo) && empty($pageInfo))) {
            unset($this->PageInfo);
        } else {
            $this->PageInfo = $pageInfo;
        }
        return $this;
    }
}
