<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUetTagsByIdsResponse StructType
 * @subpackage Structs
 */
class GetUetTagsByIdsResponse extends AbstractStructBase
{
    /**
     * The UetTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfUetTag
     */
    public $UetTags;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetUetTagsByIdsResponse
     * @uses GetUetTagsByIdsResponse::setUetTags()
     * @uses GetUetTagsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfUetTag $uetTags
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfUetTag $uetTags = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setUetTags($uetTags)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get UetTags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfUetTag|null
     */
    public function getUetTags()
    {
        return isset($this->UetTags) ? $this->UetTags : null;
    }
    /**
     * Set UetTags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfUetTag $uetTags
     * @return \StructType\GetUetTagsByIdsResponse
     */
    public function setUetTags(\ArrayType\ArrayOfUetTag $uetTags = null)
    {
        if (is_null($uetTags) || (is_array($uetTags) && empty($uetTags))) {
            unset($this->UetTags);
        } else {
            $this->UetTags = $uetTags;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetUetTagsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
