<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSharedEntityAssociationsByEntityIdsRequest StructType
 * @subpackage Structs
 */
class GetSharedEntityAssociationsByEntityIdsRequest extends AbstractStructBase
{
    /**
     * The EntityIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $EntityIds;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityType;
    /**
     * The SharedEntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityType;
    /**
     * The SharedEntityScope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityScope;
    /**
     * Constructor method for GetSharedEntityAssociationsByEntityIdsRequest
     * @uses GetSharedEntityAssociationsByEntityIdsRequest::setEntityIds()
     * @uses GetSharedEntityAssociationsByEntityIdsRequest::setEntityType()
     * @uses GetSharedEntityAssociationsByEntityIdsRequest::setSharedEntityType()
     * @uses GetSharedEntityAssociationsByEntityIdsRequest::setSharedEntityScope()
     * @param \ArrayType\ArrayOflong $entityIds
     * @param string $entityType
     * @param string $sharedEntityType
     * @param string $sharedEntityScope
     */
    public function __construct(\ArrayType\ArrayOflong $entityIds = null, $entityType = null, $sharedEntityType = null, $sharedEntityScope = null)
    {
        $this
            ->setEntityIds($entityIds)
            ->setEntityType($entityType)
            ->setSharedEntityType($sharedEntityType)
            ->setSharedEntityScope($sharedEntityScope);
    }
    /**
     * Get EntityIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getEntityIds()
    {
        return isset($this->EntityIds) ? $this->EntityIds : null;
    }
    /**
     * Set EntityIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $entityIds
     * @return \StructType\GetSharedEntityAssociationsByEntityIdsRequest
     */
    public function setEntityIds(\ArrayType\ArrayOflong $entityIds = null)
    {
        if (is_null($entityIds) || (is_array($entityIds) && empty($entityIds))) {
            unset($this->EntityIds);
        } else {
            $this->EntityIds = $entityIds;
        }
        return $this;
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\GetSharedEntityAssociationsByEntityIdsRequest
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
    /**
     * Get SharedEntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityType()
    {
        return isset($this->SharedEntityType) ? $this->SharedEntityType : null;
    }
    /**
     * Set SharedEntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharedEntityType
     * @return \StructType\GetSharedEntityAssociationsByEntityIdsRequest
     */
    public function setSharedEntityType($sharedEntityType = null)
    {
        // validation for constraint: string
        if (!is_null($sharedEntityType) && !is_string($sharedEntityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sharedEntityType, true), gettype($sharedEntityType)), __LINE__);
        }
        if (is_null($sharedEntityType) || (is_array($sharedEntityType) && empty($sharedEntityType))) {
            unset($this->SharedEntityType);
        } else {
            $this->SharedEntityType = $sharedEntityType;
        }
        return $this;
    }
    /**
     * Get SharedEntityScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityScope()
    {
        return isset($this->SharedEntityScope) ? $this->SharedEntityScope : null;
    }
    /**
     * Set SharedEntityScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EntityScope::valueIsValid()
     * @uses \EnumType\EntityScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sharedEntityScope
     * @return \StructType\GetSharedEntityAssociationsByEntityIdsRequest
     */
    public function setSharedEntityScope($sharedEntityScope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityScope::valueIsValid($sharedEntityScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityScope', is_array($sharedEntityScope) ? implode(', ', $sharedEntityScope) : var_export($sharedEntityScope, true), implode(', ', \EnumType\EntityScope::getValidValues())), __LINE__);
        }
        if (is_null($sharedEntityScope) || (is_array($sharedEntityScope) && empty($sharedEntityScope))) {
            unset($this->SharedEntityScope);
        } else {
            $this->SharedEntityScope = $sharedEntityScope;
        }
        return $this;
    }
}
