<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSharedEntitiesRequest StructType
 * @subpackage Structs
 */
class GetSharedEntitiesRequest extends AbstractStructBase
{
    /**
     * The SharedEntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityType;
    /**
     * The SharedEntityScope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityScope;
    /**
     * Constructor method for GetSharedEntitiesRequest
     * @uses GetSharedEntitiesRequest::setSharedEntityType()
     * @uses GetSharedEntitiesRequest::setSharedEntityScope()
     * @param string $sharedEntityType
     * @param string $sharedEntityScope
     */
    public function __construct($sharedEntityType = null, $sharedEntityScope = null)
    {
        $this
            ->setSharedEntityType($sharedEntityType)
            ->setSharedEntityScope($sharedEntityScope);
    }
    /**
     * Get SharedEntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityType()
    {
        return isset($this->SharedEntityType) ? $this->SharedEntityType : null;
    }
    /**
     * Set SharedEntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharedEntityType
     * @return \StructType\GetSharedEntitiesRequest
     */
    public function setSharedEntityType($sharedEntityType = null)
    {
        // validation for constraint: string
        if (!is_null($sharedEntityType) && !is_string($sharedEntityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sharedEntityType, true), gettype($sharedEntityType)), __LINE__);
        }
        if (is_null($sharedEntityType) || (is_array($sharedEntityType) && empty($sharedEntityType))) {
            unset($this->SharedEntityType);
        } else {
            $this->SharedEntityType = $sharedEntityType;
        }
        return $this;
    }
    /**
     * Get SharedEntityScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityScope()
    {
        return isset($this->SharedEntityScope) ? $this->SharedEntityScope : null;
    }
    /**
     * Set SharedEntityScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EntityScope::valueIsValid()
     * @uses \EnumType\EntityScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sharedEntityScope
     * @return \StructType\GetSharedEntitiesRequest
     */
    public function setSharedEntityScope($sharedEntityScope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityScope::valueIsValid($sharedEntityScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityScope', is_array($sharedEntityScope) ? implode(', ', $sharedEntityScope) : var_export($sharedEntityScope, true), implode(', ', \EnumType\EntityScope::getValidValues())), __LINE__);
        }
        if (is_null($sharedEntityScope) || (is_array($sharedEntityScope) && empty($sharedEntityScope))) {
            unset($this->SharedEntityScope);
        } else {
            $this->SharedEntityScope = $sharedEntityScope;
        }
        return $this;
    }
}
