<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSharedEntitiesByAccountIdRequest StructType
 * @subpackage Structs
 */
class GetSharedEntitiesByAccountIdRequest extends AbstractStructBase
{
    /**
     * The SharedEntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityType;
    /**
     * Constructor method for GetSharedEntitiesByAccountIdRequest
     * @uses GetSharedEntitiesByAccountIdRequest::setSharedEntityType()
     * @param string $sharedEntityType
     */
    public function __construct($sharedEntityType = null)
    {
        $this
            ->setSharedEntityType($sharedEntityType);
    }
    /**
     * Get SharedEntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityType()
    {
        return isset($this->SharedEntityType) ? $this->SharedEntityType : null;
    }
    /**
     * Set SharedEntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharedEntityType
     * @return \StructType\GetSharedEntitiesByAccountIdRequest
     */
    public function setSharedEntityType($sharedEntityType = null)
    {
        // validation for constraint: string
        if (!is_null($sharedEntityType) && !is_string($sharedEntityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sharedEntityType, true), gettype($sharedEntityType)), __LINE__);
        }
        if (is_null($sharedEntityType) || (is_array($sharedEntityType) && empty($sharedEntityType))) {
            unset($this->SharedEntityType);
        } else {
            $this->SharedEntityType = $sharedEntityType;
        }
        return $this;
    }
}
