<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProfileDataFileUrlRequest StructType
 * @subpackage Structs
 */
class GetProfileDataFileUrlRequest extends AbstractStructBase
{
    /**
     * The LanguageLocale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LanguageLocale;
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $ProfileType;
    /**
     * Constructor method for GetProfileDataFileUrlRequest
     * @uses GetProfileDataFileUrlRequest::setLanguageLocale()
     * @uses GetProfileDataFileUrlRequest::setProfileType()
     * @param string $languageLocale
     * @param string[] $profileType
     */
    public function __construct($languageLocale = null, array $profileType = array())
    {
        $this
            ->setLanguageLocale($languageLocale)
            ->setProfileType($profileType);
    }
    /**
     * Get LanguageLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguageLocale()
    {
        return isset($this->LanguageLocale) ? $this->LanguageLocale : null;
    }
    /**
     * Set LanguageLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $languageLocale
     * @return \StructType\GetProfileDataFileUrlRequest
     */
    public function setLanguageLocale($languageLocale = null)
    {
        // validation for constraint: string
        if (!is_null($languageLocale) && !is_string($languageLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageLocale, true), gettype($languageLocale)), __LINE__);
        }
        if (is_null($languageLocale) || (is_array($languageLocale) && empty($languageLocale))) {
            unset($this->LanguageLocale);
        } else {
            $this->LanguageLocale = $languageLocale;
        }
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string[]|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * This method is responsible for validating the values passed to the setProfileType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileTypeForArrayConstraintsFromSetProfileType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getProfileDataFileUrlRequestProfileTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ProfileType::valueIsValid($getProfileDataFileUrlRequestProfileTypeItem)) {
                $invalidValues[] = is_object($getProfileDataFileUrlRequestProfileTypeItem) ? get_class($getProfileDataFileUrlRequestProfileTypeItem) : sprintf('%s(%s)', gettype($getProfileDataFileUrlRequestProfileTypeItem), var_export($getProfileDataFileUrlRequestProfileTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProfileType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ProfileType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProfileType value
     * @uses \EnumType\ProfileType::valueIsValid()
     * @uses \EnumType\ProfileType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $profileType
     * @return \StructType\GetProfileDataFileUrlRequest
     */
    public function setProfileType(array $profileType = array())
    {
        // validation for constraint: list
        if ('' !== ($profileTypeArrayErrorMessage = self::validateProfileTypeForArrayConstraintsFromSetProfileType($profileType))) {
            throw new \InvalidArgumentException($profileTypeArrayErrorMessage, __LINE__);
        }
        $this->ProfileType = is_array($profileType) ? implode(' ', $profileType) : null;
        return $this;
    }
}
