<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNegativeKeywordsByEntityIdsRequest StructType
 * @subpackage Structs
 */
class GetNegativeKeywordsByEntityIdsRequest extends AbstractStructBase
{
    /**
     * The EntityIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $EntityIds;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityType;
    /**
     * The ParentEntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ParentEntityId;
    /**
     * Constructor method for GetNegativeKeywordsByEntityIdsRequest
     * @uses GetNegativeKeywordsByEntityIdsRequest::setEntityIds()
     * @uses GetNegativeKeywordsByEntityIdsRequest::setEntityType()
     * @uses GetNegativeKeywordsByEntityIdsRequest::setParentEntityId()
     * @param \ArrayType\ArrayOflong $entityIds
     * @param string $entityType
     * @param int $parentEntityId
     */
    public function __construct(\ArrayType\ArrayOflong $entityIds = null, $entityType = null, $parentEntityId = null)
    {
        $this
            ->setEntityIds($entityIds)
            ->setEntityType($entityType)
            ->setParentEntityId($parentEntityId);
    }
    /**
     * Get EntityIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getEntityIds()
    {
        return isset($this->EntityIds) ? $this->EntityIds : null;
    }
    /**
     * Set EntityIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $entityIds
     * @return \StructType\GetNegativeKeywordsByEntityIdsRequest
     */
    public function setEntityIds(\ArrayType\ArrayOflong $entityIds = null)
    {
        if (is_null($entityIds) || (is_array($entityIds) && empty($entityIds))) {
            unset($this->EntityIds);
        } else {
            $this->EntityIds = $entityIds;
        }
        return $this;
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\GetNegativeKeywordsByEntityIdsRequest
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
    /**
     * Get ParentEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParentEntityId()
    {
        return isset($this->ParentEntityId) ? $this->ParentEntityId : null;
    }
    /**
     * Set ParentEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parentEntityId
     * @return \StructType\GetNegativeKeywordsByEntityIdsRequest
     */
    public function setParentEntityId($parentEntityId = null)
    {
        // validation for constraint: int
        if (!is_null($parentEntityId) && !(is_int($parentEntityId) || ctype_digit($parentEntityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentEntityId, true), gettype($parentEntityId)), __LINE__);
        }
        if (is_null($parentEntityId) || (is_array($parentEntityId) && empty($parentEntityId))) {
            unset($this->ParentEntityId);
        } else {
            $this->ParentEntityId = $parentEntityId;
        }
        return $this;
    }
}
