<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMediaMetaDataByIdsResponse StructType
 * @subpackage Structs
 */
class GetMediaMetaDataByIdsResponse extends AbstractStructBase
{
    /**
     * The MediaMetaData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMediaMetaData
     */
    public $MediaMetaData;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetMediaMetaDataByIdsResponse
     * @uses GetMediaMetaDataByIdsResponse::setMediaMetaData()
     * @uses GetMediaMetaDataByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfMediaMetaData $mediaMetaData
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfMediaMetaData $mediaMetaData = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setMediaMetaData($mediaMetaData)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get MediaMetaData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMediaMetaData|null
     */
    public function getMediaMetaData()
    {
        return isset($this->MediaMetaData) ? $this->MediaMetaData : null;
    }
    /**
     * Set MediaMetaData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMediaMetaData $mediaMetaData
     * @return \StructType\GetMediaMetaDataByIdsResponse
     */
    public function setMediaMetaData(\ArrayType\ArrayOfMediaMetaData $mediaMetaData = null)
    {
        if (is_null($mediaMetaData) || (is_array($mediaMetaData) && empty($mediaMetaData))) {
            unset($this->MediaMetaData);
        } else {
            $this->MediaMetaData = $mediaMetaData;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetMediaMetaDataByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
