<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMediaMetaDataByAccountIdRequest StructType
 * @subpackage Structs
 */
class GetMediaMetaDataByAccountIdRequest extends AbstractStructBase
{
    /**
     * The MediaEnabledEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $MediaEnabledEntities;
    /**
     * The PageInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Paging
     */
    public $PageInfo;
    /**
     * Constructor method for GetMediaMetaDataByAccountIdRequest
     * @uses GetMediaMetaDataByAccountIdRequest::setMediaEnabledEntities()
     * @uses GetMediaMetaDataByAccountIdRequest::setPageInfo()
     * @param string[] $mediaEnabledEntities
     * @param \StructType\Paging $pageInfo
     */
    public function __construct(array $mediaEnabledEntities = array(), \StructType\Paging $pageInfo = null)
    {
        $this
            ->setMediaEnabledEntities($mediaEnabledEntities)
            ->setPageInfo($pageInfo);
    }
    /**
     * Get MediaEnabledEntities value
     * @return string[]|null
     */
    public function getMediaEnabledEntities()
    {
        return $this->MediaEnabledEntities;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaEnabledEntities method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaEnabledEntities method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaEnabledEntitiesForArrayConstraintsFromSetMediaEnabledEntities(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getMediaMetaDataByAccountIdRequestMediaEnabledEntitiesItem) {
            // validation for constraint: enumeration
            if (!\EnumType\MediaEnabledEntityFilter::valueIsValid($getMediaMetaDataByAccountIdRequestMediaEnabledEntitiesItem)) {
                $invalidValues[] = is_object($getMediaMetaDataByAccountIdRequestMediaEnabledEntitiesItem) ? get_class($getMediaMetaDataByAccountIdRequestMediaEnabledEntitiesItem) : sprintf('%s(%s)', gettype($getMediaMetaDataByAccountIdRequestMediaEnabledEntitiesItem), var_export($getMediaMetaDataByAccountIdRequestMediaEnabledEntitiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MediaEnabledEntityFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\MediaEnabledEntityFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MediaEnabledEntities value
     * @uses \EnumType\MediaEnabledEntityFilter::valueIsValid()
     * @uses \EnumType\MediaEnabledEntityFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $mediaEnabledEntities
     * @return \StructType\GetMediaMetaDataByAccountIdRequest
     */
    public function setMediaEnabledEntities(array $mediaEnabledEntities = array())
    {
        // validation for constraint: list
        if ('' !== ($mediaEnabledEntitiesArrayErrorMessage = self::validateMediaEnabledEntitiesForArrayConstraintsFromSetMediaEnabledEntities($mediaEnabledEntities))) {
            throw new \InvalidArgumentException($mediaEnabledEntitiesArrayErrorMessage, __LINE__);
        }
        $this->MediaEnabledEntities = is_array($mediaEnabledEntities) ? implode(' ', $mediaEnabledEntities) : null;
        return $this;
    }
    /**
     * Get PageInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Paging|null
     */
    public function getPageInfo()
    {
        return isset($this->PageInfo) ? $this->PageInfo : null;
    }
    /**
     * Set PageInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Paging $pageInfo
     * @return \StructType\GetMediaMetaDataByAccountIdRequest
     */
    public function setPageInfo(\StructType\Paging $pageInfo = null)
    {
        if (is_null($pageInfo) || (is_array($pageInfo) && empty($pageInfo))) {
            unset($this->PageInfo);
        } else {
            $this->PageInfo = $pageInfo;
        }
        return $this;
    }
}
