<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMediaAssociationsResponse StructType
 * @subpackage Structs
 */
class GetMediaAssociationsResponse extends AbstractStructBase
{
    /**
     * The MediaAssociations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfArrayOfMediaAssociation
     */
    public $MediaAssociations;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetMediaAssociationsResponse
     * @uses GetMediaAssociationsResponse::setMediaAssociations()
     * @uses GetMediaAssociationsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfArrayOfMediaAssociation $mediaAssociations
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfArrayOfMediaAssociation $mediaAssociations = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setMediaAssociations($mediaAssociations)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get MediaAssociations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfArrayOfMediaAssociation|null
     */
    public function getMediaAssociations()
    {
        return isset($this->MediaAssociations) ? $this->MediaAssociations : null;
    }
    /**
     * Set MediaAssociations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfArrayOfMediaAssociation $mediaAssociations
     * @return \StructType\GetMediaAssociationsResponse
     */
    public function setMediaAssociations(\ArrayType\ArrayOfArrayOfMediaAssociation $mediaAssociations = null)
    {
        if (is_null($mediaAssociations) || (is_array($mediaAssociations) && empty($mediaAssociations))) {
            unset($this->MediaAssociations);
        } else {
            $this->MediaAssociations = $mediaAssociations;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetMediaAssociationsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
