<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetListItemsBySharedListRequest StructType
 * @subpackage Structs
 */
class GetListItemsBySharedListRequest extends AbstractStructBase
{
    /**
     * The SharedList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SharedList
     */
    public $SharedList;
    /**
     * The SharedEntityScope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityScope;
    /**
     * Constructor method for GetListItemsBySharedListRequest
     * @uses GetListItemsBySharedListRequest::setSharedList()
     * @uses GetListItemsBySharedListRequest::setSharedEntityScope()
     * @param \StructType\SharedList $sharedList
     * @param string $sharedEntityScope
     */
    public function __construct(\StructType\SharedList $sharedList = null, $sharedEntityScope = null)
    {
        $this
            ->setSharedList($sharedList)
            ->setSharedEntityScope($sharedEntityScope);
    }
    /**
     * Get SharedList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SharedList|null
     */
    public function getSharedList()
    {
        return isset($this->SharedList) ? $this->SharedList : null;
    }
    /**
     * Set SharedList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SharedList $sharedList
     * @return \StructType\GetListItemsBySharedListRequest
     */
    public function setSharedList(\StructType\SharedList $sharedList = null)
    {
        if (is_null($sharedList) || (is_array($sharedList) && empty($sharedList))) {
            unset($this->SharedList);
        } else {
            $this->SharedList = $sharedList;
        }
        return $this;
    }
    /**
     * Get SharedEntityScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityScope()
    {
        return isset($this->SharedEntityScope) ? $this->SharedEntityScope : null;
    }
    /**
     * Set SharedEntityScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EntityScope::valueIsValid()
     * @uses \EnumType\EntityScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sharedEntityScope
     * @return \StructType\GetListItemsBySharedListRequest
     */
    public function setSharedEntityScope($sharedEntityScope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityScope::valueIsValid($sharedEntityScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityScope', is_array($sharedEntityScope) ? implode(', ', $sharedEntityScope) : var_export($sharedEntityScope, true), implode(', ', \EnumType\EntityScope::getValidValues())), __LINE__);
        }
        if (is_null($sharedEntityScope) || (is_array($sharedEntityScope) && empty($sharedEntityScope))) {
            unset($this->SharedEntityScope);
        } else {
            $this->SharedEntityScope = $sharedEntityScope;
        }
        return $this;
    }
}
