<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLabelsByIdsResponse StructType
 * @subpackage Structs
 */
class GetLabelsByIdsResponse extends AbstractStructBase
{
    /**
     * The Labels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLabel
     */
    public $Labels;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetLabelsByIdsResponse
     * @uses GetLabelsByIdsResponse::setLabels()
     * @uses GetLabelsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfLabel $labels
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfLabel $labels = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setLabels($labels)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get Labels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLabel|null
     */
    public function getLabels()
    {
        return isset($this->Labels) ? $this->Labels : null;
    }
    /**
     * Set Labels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLabel $labels
     * @return \StructType\GetLabelsByIdsResponse
     */
    public function setLabels(\ArrayType\ArrayOfLabel $labels = null)
    {
        if (is_null($labels) || (is_array($labels) && empty($labels))) {
            unset($this->Labels);
        } else {
            $this->Labels = $labels;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetLabelsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
