<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLabelAssociationsByLabelIdsResponse StructType
 * @subpackage Structs
 */
class GetLabelAssociationsByLabelIdsResponse extends AbstractStructBase
{
    /**
     * The LabelAssociations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLabelAssociation
     */
    public $LabelAssociations;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetLabelAssociationsByLabelIdsResponse
     * @uses GetLabelAssociationsByLabelIdsResponse::setLabelAssociations()
     * @uses GetLabelAssociationsByLabelIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfLabelAssociation $labelAssociations
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfLabelAssociation $labelAssociations = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setLabelAssociations($labelAssociations)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get LabelAssociations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLabelAssociation|null
     */
    public function getLabelAssociations()
    {
        return isset($this->LabelAssociations) ? $this->LabelAssociations : null;
    }
    /**
     * Set LabelAssociations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLabelAssociation $labelAssociations
     * @return \StructType\GetLabelAssociationsByLabelIdsResponse
     */
    public function setLabelAssociations(\ArrayType\ArrayOfLabelAssociation $labelAssociations = null)
    {
        if (is_null($labelAssociations) || (is_array($labelAssociations) && empty($labelAssociations))) {
            unset($this->LabelAssociations);
        } else {
            $this->LabelAssociations = $labelAssociations;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetLabelAssociationsByLabelIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
