<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLabelAssociationsByEntityIdsRequest StructType
 * @subpackage Structs
 */
class GetLabelAssociationsByEntityIdsRequest extends AbstractStructBase
{
    /**
     * The EntityIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $EntityIds;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntityType;
    /**
     * Constructor method for GetLabelAssociationsByEntityIdsRequest
     * @uses GetLabelAssociationsByEntityIdsRequest::setEntityIds()
     * @uses GetLabelAssociationsByEntityIdsRequest::setEntityType()
     * @param \ArrayType\ArrayOflong $entityIds
     * @param string $entityType
     */
    public function __construct(\ArrayType\ArrayOflong $entityIds = null, $entityType = null)
    {
        $this
            ->setEntityIds($entityIds)
            ->setEntityType($entityType);
    }
    /**
     * Get EntityIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getEntityIds()
    {
        return isset($this->EntityIds) ? $this->EntityIds : null;
    }
    /**
     * Set EntityIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $entityIds
     * @return \StructType\GetLabelAssociationsByEntityIdsRequest
     */
    public function setEntityIds(\ArrayType\ArrayOflong $entityIds = null)
    {
        if (is_null($entityIds) || (is_array($entityIds) && empty($entityIds))) {
            unset($this->EntityIds);
        } else {
            $this->EntityIds = $entityIds;
        }
        return $this;
    }
    /**
     * Get EntityType value
     * @return string|null
     */
    public function getEntityType()
    {
        return $this->EntityType;
    }
    /**
     * Set EntityType value
     * @uses \EnumType\EntityType::valueIsValid()
     * @uses \EnumType\EntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entityType
     * @return \StructType\GetLabelAssociationsByEntityIdsRequest
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityType::valueIsValid($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityType', is_array($entityType) ? implode(', ', $entityType) : var_export($entityType, true), implode(', ', \EnumType\EntityType::getValidValues())), __LINE__);
        }
        $this->EntityType = $entityType;
        return $this;
    }
}
