<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetKeywordsByIdsResponse StructType
 * @subpackage Structs
 */
class GetKeywordsByIdsResponse extends AbstractStructBase
{
    /**
     * The Keywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyword
     */
    public $Keywords;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetKeywordsByIdsResponse
     * @uses GetKeywordsByIdsResponse::setKeywords()
     * @uses GetKeywordsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfKeyword $keywords
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfKeyword $keywords = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setKeywords($keywords)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get Keywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyword|null
     */
    public function getKeywords()
    {
        return isset($this->Keywords) ? $this->Keywords : null;
    }
    /**
     * Set Keywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyword $keywords
     * @return \StructType\GetKeywordsByIdsResponse
     */
    public function setKeywords(\ArrayType\ArrayOfKeyword $keywords = null)
    {
        if (is_null($keywords) || (is_array($keywords) && empty($keywords))) {
            unset($this->Keywords);
        } else {
            $this->Keywords = $keywords;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetKeywordsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
