<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetImportJobsByIdsResponse StructType
 * @subpackage Structs
 */
class GetImportJobsByIdsResponse extends AbstractStructBase
{
    /**
     * The ImportJobs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfImportJob
     */
    public $ImportJobs;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetImportJobsByIdsResponse
     * @uses GetImportJobsByIdsResponse::setImportJobs()
     * @uses GetImportJobsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfImportJob $importJobs
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfImportJob $importJobs = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setImportJobs($importJobs)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get ImportJobs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfImportJob|null
     */
    public function getImportJobs()
    {
        return isset($this->ImportJobs) ? $this->ImportJobs : null;
    }
    /**
     * Set ImportJobs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfImportJob $importJobs
     * @return \StructType\GetImportJobsByIdsResponse
     */
    public function setImportJobs(\ArrayType\ArrayOfImportJob $importJobs = null)
    {
        if (is_null($importJobs) || (is_array($importJobs) && empty($importJobs))) {
            unset($this->ImportJobs);
        } else {
            $this->ImportJobs = $importJobs;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetImportJobsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
