<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetImportEntityIdsMappingRequest StructType
 * @subpackage Structs
 */
class GetImportEntityIdsMappingRequest extends AbstractStructBase
{
    /**
     * The ImportType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportType;
    /**
     * The SourceEntityIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $SourceEntityIds;
    /**
     * The ImportEntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImportEntityType;
    /**
     * The SourceParentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SourceParentId;
    /**
     * Constructor method for GetImportEntityIdsMappingRequest
     * @uses GetImportEntityIdsMappingRequest::setImportType()
     * @uses GetImportEntityIdsMappingRequest::setSourceEntityIds()
     * @uses GetImportEntityIdsMappingRequest::setImportEntityType()
     * @uses GetImportEntityIdsMappingRequest::setSourceParentId()
     * @param string $importType
     * @param \ArrayType\ArrayOflong $sourceEntityIds
     * @param string $importEntityType
     * @param int $sourceParentId
     */
    public function __construct($importType = null, \ArrayType\ArrayOflong $sourceEntityIds = null, $importEntityType = null, $sourceParentId = null)
    {
        $this
            ->setImportType($importType)
            ->setSourceEntityIds($sourceEntityIds)
            ->setImportEntityType($importEntityType)
            ->setSourceParentId($sourceParentId);
    }
    /**
     * Get ImportType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportType()
    {
        return isset($this->ImportType) ? $this->ImportType : null;
    }
    /**
     * Set ImportType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importType
     * @return \StructType\GetImportEntityIdsMappingRequest
     */
    public function setImportType($importType = null)
    {
        // validation for constraint: string
        if (!is_null($importType) && !is_string($importType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importType, true), gettype($importType)), __LINE__);
        }
        if (is_null($importType) || (is_array($importType) && empty($importType))) {
            unset($this->ImportType);
        } else {
            $this->ImportType = $importType;
        }
        return $this;
    }
    /**
     * Get SourceEntityIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getSourceEntityIds()
    {
        return isset($this->SourceEntityIds) ? $this->SourceEntityIds : null;
    }
    /**
     * Set SourceEntityIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $sourceEntityIds
     * @return \StructType\GetImportEntityIdsMappingRequest
     */
    public function setSourceEntityIds(\ArrayType\ArrayOflong $sourceEntityIds = null)
    {
        if (is_null($sourceEntityIds) || (is_array($sourceEntityIds) && empty($sourceEntityIds))) {
            unset($this->SourceEntityIds);
        } else {
            $this->SourceEntityIds = $sourceEntityIds;
        }
        return $this;
    }
    /**
     * Get ImportEntityType value
     * @return string|null
     */
    public function getImportEntityType()
    {
        return $this->ImportEntityType;
    }
    /**
     * Set ImportEntityType value
     * @uses \EnumType\ImportEntityType::valueIsValid()
     * @uses \EnumType\ImportEntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $importEntityType
     * @return \StructType\GetImportEntityIdsMappingRequest
     */
    public function setImportEntityType($importEntityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImportEntityType::valueIsValid($importEntityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImportEntityType', is_array($importEntityType) ? implode(', ', $importEntityType) : var_export($importEntityType, true), implode(', ', \EnumType\ImportEntityType::getValidValues())), __LINE__);
        }
        $this->ImportEntityType = $importEntityType;
        return $this;
    }
    /**
     * Get SourceParentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSourceParentId()
    {
        return isset($this->SourceParentId) ? $this->SourceParentId : null;
    }
    /**
     * Set SourceParentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sourceParentId
     * @return \StructType\GetImportEntityIdsMappingRequest
     */
    public function setSourceParentId($sourceParentId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceParentId) && !(is_int($sourceParentId) || ctype_digit($sourceParentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceParentId, true), gettype($sourceParentId)), __LINE__);
        }
        if (is_null($sourceParentId) || (is_array($sourceParentId) && empty($sourceParentId))) {
            unset($this->SourceParentId);
        } else {
            $this->SourceParentId = $sourceParentId;
        }
        return $this;
    }
}
