<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetGeoLocationsFileUrlResponse StructType
 * @subpackage Structs
 */
class GetGeoLocationsFileUrlResponse extends AbstractStructBase
{
    /**
     * The FileUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileUrl;
    /**
     * The FileUrlExpiryTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileUrlExpiryTimeUtc;
    /**
     * The LastModifiedTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastModifiedTimeUtc;
    /**
     * Constructor method for GetGeoLocationsFileUrlResponse
     * @uses GetGeoLocationsFileUrlResponse::setFileUrl()
     * @uses GetGeoLocationsFileUrlResponse::setFileUrlExpiryTimeUtc()
     * @uses GetGeoLocationsFileUrlResponse::setLastModifiedTimeUtc()
     * @param string $fileUrl
     * @param string $fileUrlExpiryTimeUtc
     * @param string $lastModifiedTimeUtc
     */
    public function __construct($fileUrl = null, $fileUrlExpiryTimeUtc = null, $lastModifiedTimeUtc = null)
    {
        $this
            ->setFileUrl($fileUrl)
            ->setFileUrlExpiryTimeUtc($fileUrlExpiryTimeUtc)
            ->setLastModifiedTimeUtc($lastModifiedTimeUtc);
    }
    /**
     * Get FileUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileUrl()
    {
        return isset($this->FileUrl) ? $this->FileUrl : null;
    }
    /**
     * Set FileUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileUrl
     * @return \StructType\GetGeoLocationsFileUrlResponse
     */
    public function setFileUrl($fileUrl = null)
    {
        // validation for constraint: string
        if (!is_null($fileUrl) && !is_string($fileUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileUrl, true), gettype($fileUrl)), __LINE__);
        }
        if (is_null($fileUrl) || (is_array($fileUrl) && empty($fileUrl))) {
            unset($this->FileUrl);
        } else {
            $this->FileUrl = $fileUrl;
        }
        return $this;
    }
    /**
     * Get FileUrlExpiryTimeUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileUrlExpiryTimeUtc()
    {
        return isset($this->FileUrlExpiryTimeUtc) ? $this->FileUrlExpiryTimeUtc : null;
    }
    /**
     * Set FileUrlExpiryTimeUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileUrlExpiryTimeUtc
     * @return \StructType\GetGeoLocationsFileUrlResponse
     */
    public function setFileUrlExpiryTimeUtc($fileUrlExpiryTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($fileUrlExpiryTimeUtc) && !is_string($fileUrlExpiryTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileUrlExpiryTimeUtc, true), gettype($fileUrlExpiryTimeUtc)), __LINE__);
        }
        if (is_null($fileUrlExpiryTimeUtc) || (is_array($fileUrlExpiryTimeUtc) && empty($fileUrlExpiryTimeUtc))) {
            unset($this->FileUrlExpiryTimeUtc);
        } else {
            $this->FileUrlExpiryTimeUtc = $fileUrlExpiryTimeUtc;
        }
        return $this;
    }
    /**
     * Get LastModifiedTimeUtc value
     * @return string|null
     */
    public function getLastModifiedTimeUtc()
    {
        return $this->LastModifiedTimeUtc;
    }
    /**
     * Set LastModifiedTimeUtc value
     * @param string $lastModifiedTimeUtc
     * @return \StructType\GetGeoLocationsFileUrlResponse
     */
    public function setLastModifiedTimeUtc($lastModifiedTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedTimeUtc) && !is_string($lastModifiedTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedTimeUtc, true), gettype($lastModifiedTimeUtc)), __LINE__);
        }
        $this->LastModifiedTimeUtc = $lastModifiedTimeUtc;
        return $this;
    }
}
