<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetExperimentsByIdsRequest StructType
 * @subpackage Structs
 */
class GetExperimentsByIdsRequest extends AbstractStructBase
{
    /**
     * The ExperimentIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $ExperimentIds;
    /**
     * The PageInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Paging
     */
    public $PageInfo;
    /**
     * Constructor method for GetExperimentsByIdsRequest
     * @uses GetExperimentsByIdsRequest::setExperimentIds()
     * @uses GetExperimentsByIdsRequest::setPageInfo()
     * @param \ArrayType\ArrayOflong $experimentIds
     * @param \StructType\Paging $pageInfo
     */
    public function __construct(\ArrayType\ArrayOflong $experimentIds = null, \StructType\Paging $pageInfo = null)
    {
        $this
            ->setExperimentIds($experimentIds)
            ->setPageInfo($pageInfo);
    }
    /**
     * Get ExperimentIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getExperimentIds()
    {
        return isset($this->ExperimentIds) ? $this->ExperimentIds : null;
    }
    /**
     * Set ExperimentIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $experimentIds
     * @return \StructType\GetExperimentsByIdsRequest
     */
    public function setExperimentIds(\ArrayType\ArrayOflong $experimentIds = null)
    {
        if (is_null($experimentIds) || (is_array($experimentIds) && empty($experimentIds))) {
            unset($this->ExperimentIds);
        } else {
            $this->ExperimentIds = $experimentIds;
        }
        return $this;
    }
    /**
     * Get PageInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Paging|null
     */
    public function getPageInfo()
    {
        return isset($this->PageInfo) ? $this->PageInfo : null;
    }
    /**
     * Set PageInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Paging $pageInfo
     * @return \StructType\GetExperimentsByIdsRequest
     */
    public function setPageInfo(\StructType\Paging $pageInfo = null)
    {
        if (is_null($pageInfo) || (is_array($pageInfo) && empty($pageInfo))) {
            unset($this->PageInfo);
        } else {
            $this->PageInfo = $pageInfo;
        }
        return $this;
    }
}
