<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEditorialReasonsByIdsRequest StructType
 * @subpackage Structs
 */
class GetEditorialReasonsByIdsRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The EntityIdToParentIdAssociations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEntityIdToParentIdAssociation
     */
    public $EntityIdToParentIdAssociations;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EntityType;
    /**
     * Constructor method for GetEditorialReasonsByIdsRequest
     * @uses GetEditorialReasonsByIdsRequest::setAccountId()
     * @uses GetEditorialReasonsByIdsRequest::setEntityIdToParentIdAssociations()
     * @uses GetEditorialReasonsByIdsRequest::setEntityType()
     * @param int $accountId
     * @param \ArrayType\ArrayOfEntityIdToParentIdAssociation $entityIdToParentIdAssociations
     * @param string $entityType
     */
    public function __construct($accountId = null, \ArrayType\ArrayOfEntityIdToParentIdAssociation $entityIdToParentIdAssociations = null, $entityType = null)
    {
        $this
            ->setAccountId($accountId)
            ->setEntityIdToParentIdAssociations($entityIdToParentIdAssociations)
            ->setEntityType($entityType);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\GetEditorialReasonsByIdsRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get EntityIdToParentIdAssociations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEntityIdToParentIdAssociation|null
     */
    public function getEntityIdToParentIdAssociations()
    {
        return isset($this->EntityIdToParentIdAssociations) ? $this->EntityIdToParentIdAssociations : null;
    }
    /**
     * Set EntityIdToParentIdAssociations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEntityIdToParentIdAssociation $entityIdToParentIdAssociations
     * @return \StructType\GetEditorialReasonsByIdsRequest
     */
    public function setEntityIdToParentIdAssociations(\ArrayType\ArrayOfEntityIdToParentIdAssociation $entityIdToParentIdAssociations = null)
    {
        if (is_null($entityIdToParentIdAssociations) || (is_array($entityIdToParentIdAssociations) && empty($entityIdToParentIdAssociations))) {
            unset($this->EntityIdToParentIdAssociations);
        } else {
            $this->EntityIdToParentIdAssociations = $entityIdToParentIdAssociations;
        }
        return $this;
    }
    /**
     * Get EntityType value
     * @return string|null
     */
    public function getEntityType()
    {
        return $this->EntityType;
    }
    /**
     * Set EntityType value
     * @uses \EnumType\EntityType::valueIsValid()
     * @uses \EnumType\EntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entityType
     * @return \StructType\GetEditorialReasonsByIdsRequest
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityType::valueIsValid($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityType', is_array($entityType) ? implode(', ', $entityType) : var_export($entityType, true), implode(', ', \EnumType\EntityType::getValidValues())), __LINE__);
        }
        $this->EntityType = $entityType;
        return $this;
    }
}
