<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConversionGoalsByTagIdsRequest StructType
 * @subpackage Structs
 */
class GetConversionGoalsByTagIdsRequest extends AbstractStructBase
{
    /**
     * The TagIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $TagIds;
    /**
     * The ConversionGoalTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $ConversionGoalTypes;
    /**
     * The ReturnAdditionalFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ReturnAdditionalFields;
    /**
     * Constructor method for GetConversionGoalsByTagIdsRequest
     * @uses GetConversionGoalsByTagIdsRequest::setTagIds()
     * @uses GetConversionGoalsByTagIdsRequest::setConversionGoalTypes()
     * @uses GetConversionGoalsByTagIdsRequest::setReturnAdditionalFields()
     * @param \ArrayType\ArrayOflong $tagIds
     * @param string[] $conversionGoalTypes
     * @param string[] $returnAdditionalFields
     */
    public function __construct(\ArrayType\ArrayOflong $tagIds = null, array $conversionGoalTypes = array(), array $returnAdditionalFields = array())
    {
        $this
            ->setTagIds($tagIds)
            ->setConversionGoalTypes($conversionGoalTypes)
            ->setReturnAdditionalFields($returnAdditionalFields);
    }
    /**
     * Get TagIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getTagIds()
    {
        return isset($this->TagIds) ? $this->TagIds : null;
    }
    /**
     * Set TagIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $tagIds
     * @return \StructType\GetConversionGoalsByTagIdsRequest
     */
    public function setTagIds(\ArrayType\ArrayOflong $tagIds = null)
    {
        if (is_null($tagIds) || (is_array($tagIds) && empty($tagIds))) {
            unset($this->TagIds);
        } else {
            $this->TagIds = $tagIds;
        }
        return $this;
    }
    /**
     * Get ConversionGoalTypes value
     * @return string[]|null
     */
    public function getConversionGoalTypes()
    {
        return $this->ConversionGoalTypes;
    }
    /**
     * This method is responsible for validating the values passed to the setConversionGoalTypes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConversionGoalTypes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConversionGoalTypesForArrayConstraintsFromSetConversionGoalTypes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getConversionGoalsByTagIdsRequestConversionGoalTypesItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ConversionGoalType::valueIsValid($getConversionGoalsByTagIdsRequestConversionGoalTypesItem)) {
                $invalidValues[] = is_object($getConversionGoalsByTagIdsRequestConversionGoalTypesItem) ? get_class($getConversionGoalsByTagIdsRequestConversionGoalTypesItem) : sprintf('%s(%s)', gettype($getConversionGoalsByTagIdsRequestConversionGoalTypesItem), var_export($getConversionGoalsByTagIdsRequestConversionGoalTypesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConversionGoalType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ConversionGoalType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConversionGoalTypes value
     * @uses \EnumType\ConversionGoalType::valueIsValid()
     * @uses \EnumType\ConversionGoalType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $conversionGoalTypes
     * @return \StructType\GetConversionGoalsByTagIdsRequest
     */
    public function setConversionGoalTypes(array $conversionGoalTypes = array())
    {
        // validation for constraint: list
        if ('' !== ($conversionGoalTypesArrayErrorMessage = self::validateConversionGoalTypesForArrayConstraintsFromSetConversionGoalTypes($conversionGoalTypes))) {
            throw new \InvalidArgumentException($conversionGoalTypesArrayErrorMessage, __LINE__);
        }
        $this->ConversionGoalTypes = is_array($conversionGoalTypes) ? implode(' ', $conversionGoalTypes) : null;
        return $this;
    }
    /**
     * Get ReturnAdditionalFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getReturnAdditionalFields()
    {
        return isset($this->ReturnAdditionalFields) ? $this->ReturnAdditionalFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnAdditionalFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnAdditionalFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getConversionGoalsByTagIdsRequestReturnAdditionalFieldsItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ConversionGoalAdditionalField::valueIsValid($getConversionGoalsByTagIdsRequestReturnAdditionalFieldsItem)) {
                $invalidValues[] = is_object($getConversionGoalsByTagIdsRequestReturnAdditionalFieldsItem) ? get_class($getConversionGoalsByTagIdsRequestReturnAdditionalFieldsItem) : sprintf('%s(%s)', gettype($getConversionGoalsByTagIdsRequestReturnAdditionalFieldsItem), var_export($getConversionGoalsByTagIdsRequestReturnAdditionalFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConversionGoalAdditionalField', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ConversionGoalAdditionalField::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnAdditionalFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ConversionGoalAdditionalField::valueIsValid()
     * @uses \EnumType\ConversionGoalAdditionalField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $returnAdditionalFields
     * @return \StructType\GetConversionGoalsByTagIdsRequest
     */
    public function setReturnAdditionalFields(array $returnAdditionalFields = array())
    {
        // validation for constraint: list
        if ('' !== ($returnAdditionalFieldsArrayErrorMessage = self::validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields($returnAdditionalFields))) {
            throw new \InvalidArgumentException($returnAdditionalFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($returnAdditionalFields) || (is_array($returnAdditionalFields) && empty($returnAdditionalFields))) {
            unset($this->ReturnAdditionalFields);
        } else {
            $this->ReturnAdditionalFields = is_array($returnAdditionalFields) ? implode(' ', $returnAdditionalFields) : null;
        }
        return $this;
    }
}
