<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConversionGoalsByIdsResponse StructType
 * @subpackage Structs
 */
class GetConversionGoalsByIdsResponse extends AbstractStructBase
{
    /**
     * The ConversionGoals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfConversionGoal
     */
    public $ConversionGoals;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetConversionGoalsByIdsResponse
     * @uses GetConversionGoalsByIdsResponse::setConversionGoals()
     * @uses GetConversionGoalsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfConversionGoal $conversionGoals
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfConversionGoal $conversionGoals = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setConversionGoals($conversionGoals)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get ConversionGoals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfConversionGoal|null
     */
    public function getConversionGoals()
    {
        return isset($this->ConversionGoals) ? $this->ConversionGoals : null;
    }
    /**
     * Set ConversionGoals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfConversionGoal $conversionGoals
     * @return \StructType\GetConversionGoalsByIdsResponse
     */
    public function setConversionGoals(\ArrayType\ArrayOfConversionGoal $conversionGoals = null)
    {
        if (is_null($conversionGoals) || (is_array($conversionGoals) && empty($conversionGoals))) {
            unset($this->ConversionGoals);
        } else {
            $this->ConversionGoals = $conversionGoals;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetConversionGoalsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
