<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConversionGoalsByIdsRequest StructType
 * @subpackage Structs
 */
class GetConversionGoalsByIdsRequest extends AbstractStructBase
{
    /**
     * The ConversionGoalIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $ConversionGoalIds;
    /**
     * The ConversionGoalTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $ConversionGoalTypes;
    /**
     * The ReturnAdditionalFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ReturnAdditionalFields;
    /**
     * Constructor method for GetConversionGoalsByIdsRequest
     * @uses GetConversionGoalsByIdsRequest::setConversionGoalIds()
     * @uses GetConversionGoalsByIdsRequest::setConversionGoalTypes()
     * @uses GetConversionGoalsByIdsRequest::setReturnAdditionalFields()
     * @param \ArrayType\ArrayOflong $conversionGoalIds
     * @param string[] $conversionGoalTypes
     * @param string[] $returnAdditionalFields
     */
    public function __construct(\ArrayType\ArrayOflong $conversionGoalIds = null, array $conversionGoalTypes = array(), array $returnAdditionalFields = array())
    {
        $this
            ->setConversionGoalIds($conversionGoalIds)
            ->setConversionGoalTypes($conversionGoalTypes)
            ->setReturnAdditionalFields($returnAdditionalFields);
    }
    /**
     * Get ConversionGoalIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getConversionGoalIds()
    {
        return isset($this->ConversionGoalIds) ? $this->ConversionGoalIds : null;
    }
    /**
     * Set ConversionGoalIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $conversionGoalIds
     * @return \StructType\GetConversionGoalsByIdsRequest
     */
    public function setConversionGoalIds(\ArrayType\ArrayOflong $conversionGoalIds = null)
    {
        if (is_null($conversionGoalIds) || (is_array($conversionGoalIds) && empty($conversionGoalIds))) {
            unset($this->ConversionGoalIds);
        } else {
            $this->ConversionGoalIds = $conversionGoalIds;
        }
        return $this;
    }
    /**
     * Get ConversionGoalTypes value
     * @return string[]|null
     */
    public function getConversionGoalTypes()
    {
        return $this->ConversionGoalTypes;
    }
    /**
     * This method is responsible for validating the values passed to the setConversionGoalTypes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConversionGoalTypes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConversionGoalTypesForArrayConstraintsFromSetConversionGoalTypes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getConversionGoalsByIdsRequestConversionGoalTypesItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ConversionGoalType::valueIsValid($getConversionGoalsByIdsRequestConversionGoalTypesItem)) {
                $invalidValues[] = is_object($getConversionGoalsByIdsRequestConversionGoalTypesItem) ? get_class($getConversionGoalsByIdsRequestConversionGoalTypesItem) : sprintf('%s(%s)', gettype($getConversionGoalsByIdsRequestConversionGoalTypesItem), var_export($getConversionGoalsByIdsRequestConversionGoalTypesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConversionGoalType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ConversionGoalType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConversionGoalTypes value
     * @uses \EnumType\ConversionGoalType::valueIsValid()
     * @uses \EnumType\ConversionGoalType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $conversionGoalTypes
     * @return \StructType\GetConversionGoalsByIdsRequest
     */
    public function setConversionGoalTypes(array $conversionGoalTypes = array())
    {
        // validation for constraint: list
        if ('' !== ($conversionGoalTypesArrayErrorMessage = self::validateConversionGoalTypesForArrayConstraintsFromSetConversionGoalTypes($conversionGoalTypes))) {
            throw new \InvalidArgumentException($conversionGoalTypesArrayErrorMessage, __LINE__);
        }
        $this->ConversionGoalTypes = is_array($conversionGoalTypes) ? implode(' ', $conversionGoalTypes) : null;
        return $this;
    }
    /**
     * Get ReturnAdditionalFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getReturnAdditionalFields()
    {
        return isset($this->ReturnAdditionalFields) ? $this->ReturnAdditionalFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnAdditionalFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnAdditionalFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getConversionGoalsByIdsRequestReturnAdditionalFieldsItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ConversionGoalAdditionalField::valueIsValid($getConversionGoalsByIdsRequestReturnAdditionalFieldsItem)) {
                $invalidValues[] = is_object($getConversionGoalsByIdsRequestReturnAdditionalFieldsItem) ? get_class($getConversionGoalsByIdsRequestReturnAdditionalFieldsItem) : sprintf('%s(%s)', gettype($getConversionGoalsByIdsRequestReturnAdditionalFieldsItem), var_export($getConversionGoalsByIdsRequestReturnAdditionalFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ConversionGoalAdditionalField', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ConversionGoalAdditionalField::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnAdditionalFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ConversionGoalAdditionalField::valueIsValid()
     * @uses \EnumType\ConversionGoalAdditionalField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $returnAdditionalFields
     * @return \StructType\GetConversionGoalsByIdsRequest
     */
    public function setReturnAdditionalFields(array $returnAdditionalFields = array())
    {
        // validation for constraint: list
        if ('' !== ($returnAdditionalFieldsArrayErrorMessage = self::validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields($returnAdditionalFields))) {
            throw new \InvalidArgumentException($returnAdditionalFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($returnAdditionalFields) || (is_array($returnAdditionalFields) && empty($returnAdditionalFields))) {
            unset($this->ReturnAdditionalFields);
        } else {
            $this->ReturnAdditionalFields = is_array($returnAdditionalFields) ? implode(' ', $returnAdditionalFields) : null;
        }
        return $this;
    }
}
