<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConfigValueResponse StructType
 * @subpackage Structs
 */
class GetConfigValueResponse extends AbstractStructBase
{
    /**
     * The ConfigValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfigValue;
    /**
     * Constructor method for GetConfigValueResponse
     * @uses GetConfigValueResponse::setConfigValue()
     * @param string $configValue
     */
    public function __construct($configValue = null)
    {
        $this
            ->setConfigValue($configValue);
    }
    /**
     * Get ConfigValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfigValue()
    {
        return isset($this->ConfigValue) ? $this->ConfigValue : null;
    }
    /**
     * Set ConfigValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $configValue
     * @return \StructType\GetConfigValueResponse
     */
    public function setConfigValue($configValue = null)
    {
        // validation for constraint: string
        if (!is_null($configValue) && !is_string($configValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configValue, true), gettype($configValue)), __LINE__);
        }
        if (is_null($configValue) || (is_array($configValue) && empty($configValue))) {
            unset($this->ConfigValue);
        } else {
            $this->ConfigValue = $configValue;
        }
        return $this;
    }
}
