<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConfigValueRequest StructType
 * @subpackage Structs
 */
class GetConfigValueRequest extends AbstractStructBase
{
    /**
     * The ConfigKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfigKey;
    /**
     * Constructor method for GetConfigValueRequest
     * @uses GetConfigValueRequest::setConfigKey()
     * @param string $configKey
     */
    public function __construct($configKey = null)
    {
        $this
            ->setConfigKey($configKey);
    }
    /**
     * Get ConfigKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfigKey()
    {
        return isset($this->ConfigKey) ? $this->ConfigKey : null;
    }
    /**
     * Set ConfigKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $configKey
     * @return \StructType\GetConfigValueRequest
     */
    public function setConfigKey($configKey = null)
    {
        // validation for constraint: string
        if (!is_null($configKey) && !is_string($configKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configKey, true), gettype($configKey)), __LINE__);
        }
        if (is_null($configKey) || (is_array($configKey) && empty($configKey))) {
            unset($this->ConfigKey);
        } else {
            $this->ConfigKey = $configKey;
        }
        return $this;
    }
}
