<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCampaignsByIdsResponse StructType
 * @subpackage Structs
 */
class GetCampaignsByIdsResponse extends AbstractStructBase
{
    /**
     * The Campaigns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCampaign
     */
    public $Campaigns;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetCampaignsByIdsResponse
     * @uses GetCampaignsByIdsResponse::setCampaigns()
     * @uses GetCampaignsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfCampaign $campaigns
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfCampaign $campaigns = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setCampaigns($campaigns)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get Campaigns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCampaign|null
     */
    public function getCampaigns()
    {
        return isset($this->Campaigns) ? $this->Campaigns : null;
    }
    /**
     * Set Campaigns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCampaign $campaigns
     * @return \StructType\GetCampaignsByIdsResponse
     */
    public function setCampaigns(\ArrayType\ArrayOfCampaign $campaigns = null)
    {
        if (is_null($campaigns) || (is_array($campaigns) && empty($campaigns))) {
            unset($this->Campaigns);
        } else {
            $this->Campaigns = $campaigns;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetCampaignsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
