<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCampaignSizesByAccountIdRequest StructType
 * @subpackage Structs
 */
class GetCampaignSizesByAccountIdRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The CampaignIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $CampaignIds;
    /**
     * Constructor method for GetCampaignSizesByAccountIdRequest
     * @uses GetCampaignSizesByAccountIdRequest::setAccountId()
     * @uses GetCampaignSizesByAccountIdRequest::setCampaignIds()
     * @param int $accountId
     * @param \ArrayType\ArrayOflong $campaignIds
     */
    public function __construct($accountId = null, \ArrayType\ArrayOflong $campaignIds = null)
    {
        $this
            ->setAccountId($accountId)
            ->setCampaignIds($campaignIds);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\GetCampaignSizesByAccountIdRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get CampaignIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getCampaignIds()
    {
        return isset($this->CampaignIds) ? $this->CampaignIds : null;
    }
    /**
     * Set CampaignIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $campaignIds
     * @return \StructType\GetCampaignSizesByAccountIdRequest
     */
    public function setCampaignIds(\ArrayType\ArrayOflong $campaignIds = null)
    {
        if (is_null($campaignIds) || (is_array($campaignIds) && empty($campaignIds))) {
            unset($this->CampaignIds);
        } else {
            $this->CampaignIds = $campaignIds;
        }
        return $this;
    }
}
