<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCampaignCriterionsByIdsRequest StructType
 * @subpackage Structs
 */
class GetCampaignCriterionsByIdsRequest extends AbstractStructBase
{
    /**
     * The CampaignCriterionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $CampaignCriterionIds;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignId;
    /**
     * The CriterionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $CriterionType;
    /**
     * The ReturnAdditionalFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ReturnAdditionalFields;
    /**
     * Constructor method for GetCampaignCriterionsByIdsRequest
     * @uses GetCampaignCriterionsByIdsRequest::setCampaignCriterionIds()
     * @uses GetCampaignCriterionsByIdsRequest::setCampaignId()
     * @uses GetCampaignCriterionsByIdsRequest::setCriterionType()
     * @uses GetCampaignCriterionsByIdsRequest::setReturnAdditionalFields()
     * @param \ArrayType\ArrayOflong $campaignCriterionIds
     * @param int $campaignId
     * @param string[] $criterionType
     * @param string[] $returnAdditionalFields
     */
    public function __construct(\ArrayType\ArrayOflong $campaignCriterionIds = null, $campaignId = null, array $criterionType = array(), array $returnAdditionalFields = array())
    {
        $this
            ->setCampaignCriterionIds($campaignCriterionIds)
            ->setCampaignId($campaignId)
            ->setCriterionType($criterionType)
            ->setReturnAdditionalFields($returnAdditionalFields);
    }
    /**
     * Get CampaignCriterionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getCampaignCriterionIds()
    {
        return isset($this->CampaignCriterionIds) ? $this->CampaignCriterionIds : null;
    }
    /**
     * Set CampaignCriterionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $campaignCriterionIds
     * @return \StructType\GetCampaignCriterionsByIdsRequest
     */
    public function setCampaignCriterionIds(\ArrayType\ArrayOflong $campaignCriterionIds = null)
    {
        if (is_null($campaignCriterionIds) || (is_array($campaignCriterionIds) && empty($campaignCriterionIds))) {
            unset($this->CampaignCriterionIds);
        } else {
            $this->CampaignCriterionIds = $campaignCriterionIds;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\GetCampaignCriterionsByIdsRequest
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get CriterionType value
     * @return string[]|null
     */
    public function getCriterionType()
    {
        return $this->CriterionType;
    }
    /**
     * This method is responsible for validating the values passed to the setCriterionType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCriterionType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCriterionTypeForArrayConstraintsFromSetCriterionType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getCampaignCriterionsByIdsRequestCriterionTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CampaignCriterionType::valueIsValid($getCampaignCriterionsByIdsRequestCriterionTypeItem)) {
                $invalidValues[] = is_object($getCampaignCriterionsByIdsRequestCriterionTypeItem) ? get_class($getCampaignCriterionsByIdsRequestCriterionTypeItem) : sprintf('%s(%s)', gettype($getCampaignCriterionsByIdsRequestCriterionTypeItem), var_export($getCampaignCriterionsByIdsRequestCriterionTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignCriterionType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CampaignCriterionType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CriterionType value
     * @uses \EnumType\CampaignCriterionType::valueIsValid()
     * @uses \EnumType\CampaignCriterionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $criterionType
     * @return \StructType\GetCampaignCriterionsByIdsRequest
     */
    public function setCriterionType(array $criterionType = array())
    {
        // validation for constraint: list
        if ('' !== ($criterionTypeArrayErrorMessage = self::validateCriterionTypeForArrayConstraintsFromSetCriterionType($criterionType))) {
            throw new \InvalidArgumentException($criterionTypeArrayErrorMessage, __LINE__);
        }
        $this->CriterionType = is_array($criterionType) ? implode(' ', $criterionType) : null;
        return $this;
    }
    /**
     * Get ReturnAdditionalFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getReturnAdditionalFields()
    {
        return isset($this->ReturnAdditionalFields) ? $this->ReturnAdditionalFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnAdditionalFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnAdditionalFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getCampaignCriterionsByIdsRequestReturnAdditionalFieldsItem) {
            // validation for constraint: enumeration
            if (!\EnumType\CriterionAdditionalField::valueIsValid($getCampaignCriterionsByIdsRequestReturnAdditionalFieldsItem)) {
                $invalidValues[] = is_object($getCampaignCriterionsByIdsRequestReturnAdditionalFieldsItem) ? get_class($getCampaignCriterionsByIdsRequestReturnAdditionalFieldsItem) : sprintf('%s(%s)', gettype($getCampaignCriterionsByIdsRequestReturnAdditionalFieldsItem), var_export($getCampaignCriterionsByIdsRequestReturnAdditionalFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CriterionAdditionalField', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\CriterionAdditionalField::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnAdditionalFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CriterionAdditionalField::valueIsValid()
     * @uses \EnumType\CriterionAdditionalField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $returnAdditionalFields
     * @return \StructType\GetCampaignCriterionsByIdsRequest
     */
    public function setReturnAdditionalFields(array $returnAdditionalFields = array())
    {
        // validation for constraint: list
        if ('' !== ($returnAdditionalFieldsArrayErrorMessage = self::validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields($returnAdditionalFields))) {
            throw new \InvalidArgumentException($returnAdditionalFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($returnAdditionalFields) || (is_array($returnAdditionalFields) && empty($returnAdditionalFields))) {
            unset($this->ReturnAdditionalFields);
        } else {
            $this->ReturnAdditionalFields = is_array($returnAdditionalFields) ? implode(' ', $returnAdditionalFields) : null;
        }
        return $this;
    }
}
