<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAudiencesByIdsResponse StructType
 * @subpackage Structs
 */
class GetAudiencesByIdsResponse extends AbstractStructBase
{
    /**
     * The Audiences
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAudience
     */
    public $Audiences;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetAudiencesByIdsResponse
     * @uses GetAudiencesByIdsResponse::setAudiences()
     * @uses GetAudiencesByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfAudience $audiences
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfAudience $audiences = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setAudiences($audiences)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get Audiences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAudience|null
     */
    public function getAudiences()
    {
        return isset($this->Audiences) ? $this->Audiences : null;
    }
    /**
     * Set Audiences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAudience $audiences
     * @return \StructType\GetAudiencesByIdsResponse
     */
    public function setAudiences(\ArrayType\ArrayOfAudience $audiences = null)
    {
        if (is_null($audiences) || (is_array($audiences) && empty($audiences))) {
            unset($this->Audiences);
        } else {
            $this->Audiences = $audiences;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetAudiencesByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
