<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdsByIdsRequest StructType
 * @subpackage Structs
 */
class GetAdsByIdsRequest extends AbstractStructBase
{
    /**
     * The AdGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdGroupId;
    /**
     * The AdIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AdIds;
    /**
     * The AdTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdType
     */
    public $AdTypes;
    /**
     * The ReturnAdditionalFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ReturnAdditionalFields;
    /**
     * Constructor method for GetAdsByIdsRequest
     * @uses GetAdsByIdsRequest::setAdGroupId()
     * @uses GetAdsByIdsRequest::setAdIds()
     * @uses GetAdsByIdsRequest::setAdTypes()
     * @uses GetAdsByIdsRequest::setReturnAdditionalFields()
     * @param int $adGroupId
     * @param \ArrayType\ArrayOflong $adIds
     * @param \ArrayType\ArrayOfAdType $adTypes
     * @param string[] $returnAdditionalFields
     */
    public function __construct($adGroupId = null, \ArrayType\ArrayOflong $adIds = null, \ArrayType\ArrayOfAdType $adTypes = null, array $returnAdditionalFields = array())
    {
        $this
            ->setAdGroupId($adGroupId)
            ->setAdIds($adIds)
            ->setAdTypes($adTypes)
            ->setReturnAdditionalFields($returnAdditionalFields);
    }
    /**
     * Get AdGroupId value
     * @return int|null
     */
    public function getAdGroupId()
    {
        return $this->AdGroupId;
    }
    /**
     * Set AdGroupId value
     * @param int $adGroupId
     * @return \StructType\GetAdsByIdsRequest
     */
    public function setAdGroupId($adGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($adGroupId) && !(is_int($adGroupId) || ctype_digit($adGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adGroupId, true), gettype($adGroupId)), __LINE__);
        }
        $this->AdGroupId = $adGroupId;
        return $this;
    }
    /**
     * Get AdIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAdIds()
    {
        return isset($this->AdIds) ? $this->AdIds : null;
    }
    /**
     * Set AdIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $adIds
     * @return \StructType\GetAdsByIdsRequest
     */
    public function setAdIds(\ArrayType\ArrayOflong $adIds = null)
    {
        if (is_null($adIds) || (is_array($adIds) && empty($adIds))) {
            unset($this->AdIds);
        } else {
            $this->AdIds = $adIds;
        }
        return $this;
    }
    /**
     * Get AdTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdType|null
     */
    public function getAdTypes()
    {
        return isset($this->AdTypes) ? $this->AdTypes : null;
    }
    /**
     * Set AdTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdType $adTypes
     * @return \StructType\GetAdsByIdsRequest
     */
    public function setAdTypes(\ArrayType\ArrayOfAdType $adTypes = null)
    {
        if (is_null($adTypes) || (is_array($adTypes) && empty($adTypes))) {
            unset($this->AdTypes);
        } else {
            $this->AdTypes = $adTypes;
        }
        return $this;
    }
    /**
     * Get ReturnAdditionalFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getReturnAdditionalFields()
    {
        return isset($this->ReturnAdditionalFields) ? $this->ReturnAdditionalFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnAdditionalFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnAdditionalFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getAdsByIdsRequestReturnAdditionalFieldsItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdAdditionalField::valueIsValid($getAdsByIdsRequestReturnAdditionalFieldsItem)) {
                $invalidValues[] = is_object($getAdsByIdsRequestReturnAdditionalFieldsItem) ? get_class($getAdsByIdsRequestReturnAdditionalFieldsItem) : sprintf('%s(%s)', gettype($getAdsByIdsRequestReturnAdditionalFieldsItem), var_export($getAdsByIdsRequestReturnAdditionalFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdAdditionalField', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdAdditionalField::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnAdditionalFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdAdditionalField::valueIsValid()
     * @uses \EnumType\AdAdditionalField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $returnAdditionalFields
     * @return \StructType\GetAdsByIdsRequest
     */
    public function setReturnAdditionalFields(array $returnAdditionalFields = array())
    {
        // validation for constraint: list
        if ('' !== ($returnAdditionalFieldsArrayErrorMessage = self::validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields($returnAdditionalFields))) {
            throw new \InvalidArgumentException($returnAdditionalFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($returnAdditionalFields) || (is_array($returnAdditionalFields) && empty($returnAdditionalFields))) {
            unset($this->ReturnAdditionalFields);
        } else {
            $this->ReturnAdditionalFields = is_array($returnAdditionalFields) ? implode(' ', $returnAdditionalFields) : null;
        }
        return $this;
    }
}
