<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdGroupsByIdsResponse StructType
 * @subpackage Structs
 */
class GetAdGroupsByIdsResponse extends AbstractStructBase
{
    /**
     * The AdGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdGroup
     */
    public $AdGroups;
    /**
     * The PartialErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBatchError
     */
    public $PartialErrors;
    /**
     * Constructor method for GetAdGroupsByIdsResponse
     * @uses GetAdGroupsByIdsResponse::setAdGroups()
     * @uses GetAdGroupsByIdsResponse::setPartialErrors()
     * @param \ArrayType\ArrayOfAdGroup $adGroups
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     */
    public function __construct(\ArrayType\ArrayOfAdGroup $adGroups = null, \ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        $this
            ->setAdGroups($adGroups)
            ->setPartialErrors($partialErrors);
    }
    /**
     * Get AdGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdGroup|null
     */
    public function getAdGroups()
    {
        return isset($this->AdGroups) ? $this->AdGroups : null;
    }
    /**
     * Set AdGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdGroup $adGroups
     * @return \StructType\GetAdGroupsByIdsResponse
     */
    public function setAdGroups(\ArrayType\ArrayOfAdGroup $adGroups = null)
    {
        if (is_null($adGroups) || (is_array($adGroups) && empty($adGroups))) {
            unset($this->AdGroups);
        } else {
            $this->AdGroups = $adGroups;
        }
        return $this;
    }
    /**
     * Get PartialErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBatchError|null
     */
    public function getPartialErrors()
    {
        return isset($this->PartialErrors) ? $this->PartialErrors : null;
    }
    /**
     * Set PartialErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBatchError $partialErrors
     * @return \StructType\GetAdGroupsByIdsResponse
     */
    public function setPartialErrors(\ArrayType\ArrayOfBatchError $partialErrors = null)
    {
        if (is_null($partialErrors) || (is_array($partialErrors) && empty($partialErrors))) {
            unset($this->PartialErrors);
        } else {
            $this->PartialErrors = $partialErrors;
        }
        return $this;
    }
}
