<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdExtensionsEditorialReasonsRequest StructType
 * @subpackage Structs
 */
class GetAdExtensionsEditorialReasonsRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The AdExtensionIdToEntityIdAssociations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAdExtensionIdToEntityIdAssociation
     */
    public $AdExtensionIdToEntityIdAssociations;
    /**
     * The AssociationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AssociationType;
    /**
     * Constructor method for GetAdExtensionsEditorialReasonsRequest
     * @uses GetAdExtensionsEditorialReasonsRequest::setAccountId()
     * @uses GetAdExtensionsEditorialReasonsRequest::setAdExtensionIdToEntityIdAssociations()
     * @uses GetAdExtensionsEditorialReasonsRequest::setAssociationType()
     * @param int $accountId
     * @param \ArrayType\ArrayOfAdExtensionIdToEntityIdAssociation $adExtensionIdToEntityIdAssociations
     * @param string $associationType
     */
    public function __construct($accountId = null, \ArrayType\ArrayOfAdExtensionIdToEntityIdAssociation $adExtensionIdToEntityIdAssociations = null, $associationType = null)
    {
        $this
            ->setAccountId($accountId)
            ->setAdExtensionIdToEntityIdAssociations($adExtensionIdToEntityIdAssociations)
            ->setAssociationType($associationType);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\GetAdExtensionsEditorialReasonsRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get AdExtensionIdToEntityIdAssociations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAdExtensionIdToEntityIdAssociation|null
     */
    public function getAdExtensionIdToEntityIdAssociations()
    {
        return isset($this->AdExtensionIdToEntityIdAssociations) ? $this->AdExtensionIdToEntityIdAssociations : null;
    }
    /**
     * Set AdExtensionIdToEntityIdAssociations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAdExtensionIdToEntityIdAssociation $adExtensionIdToEntityIdAssociations
     * @return \StructType\GetAdExtensionsEditorialReasonsRequest
     */
    public function setAdExtensionIdToEntityIdAssociations(\ArrayType\ArrayOfAdExtensionIdToEntityIdAssociation $adExtensionIdToEntityIdAssociations = null)
    {
        if (is_null($adExtensionIdToEntityIdAssociations) || (is_array($adExtensionIdToEntityIdAssociations) && empty($adExtensionIdToEntityIdAssociations))) {
            unset($this->AdExtensionIdToEntityIdAssociations);
        } else {
            $this->AdExtensionIdToEntityIdAssociations = $adExtensionIdToEntityIdAssociations;
        }
        return $this;
    }
    /**
     * Get AssociationType value
     * @return string|null
     */
    public function getAssociationType()
    {
        return $this->AssociationType;
    }
    /**
     * Set AssociationType value
     * @uses \EnumType\AssociationType::valueIsValid()
     * @uses \EnumType\AssociationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $associationType
     * @return \StructType\GetAdExtensionsEditorialReasonsRequest
     */
    public function setAssociationType($associationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AssociationType::valueIsValid($associationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AssociationType', is_array($associationType) ? implode(', ', $associationType) : var_export($associationType, true), implode(', ', \EnumType\AssociationType::getValidValues())), __LINE__);
        }
        $this->AssociationType = $associationType;
        return $this;
    }
}
