<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdExtensionsByIdsRequest StructType
 * @subpackage Structs
 */
class GetAdExtensionsByIdsRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The AdExtensionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AdExtensionIds;
    /**
     * The AdExtensionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AdExtensionType;
    /**
     * The ReturnAdditionalFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ReturnAdditionalFields;
    /**
     * Constructor method for GetAdExtensionsByIdsRequest
     * @uses GetAdExtensionsByIdsRequest::setAccountId()
     * @uses GetAdExtensionsByIdsRequest::setAdExtensionIds()
     * @uses GetAdExtensionsByIdsRequest::setAdExtensionType()
     * @uses GetAdExtensionsByIdsRequest::setReturnAdditionalFields()
     * @param int $accountId
     * @param \ArrayType\ArrayOflong $adExtensionIds
     * @param string[] $adExtensionType
     * @param string[] $returnAdditionalFields
     */
    public function __construct($accountId = null, \ArrayType\ArrayOflong $adExtensionIds = null, array $adExtensionType = array(), array $returnAdditionalFields = array())
    {
        $this
            ->setAccountId($accountId)
            ->setAdExtensionIds($adExtensionIds)
            ->setAdExtensionType($adExtensionType)
            ->setReturnAdditionalFields($returnAdditionalFields);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\GetAdExtensionsByIdsRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get AdExtensionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAdExtensionIds()
    {
        return isset($this->AdExtensionIds) ? $this->AdExtensionIds : null;
    }
    /**
     * Set AdExtensionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $adExtensionIds
     * @return \StructType\GetAdExtensionsByIdsRequest
     */
    public function setAdExtensionIds(\ArrayType\ArrayOflong $adExtensionIds = null)
    {
        if (is_null($adExtensionIds) || (is_array($adExtensionIds) && empty($adExtensionIds))) {
            unset($this->AdExtensionIds);
        } else {
            $this->AdExtensionIds = $adExtensionIds;
        }
        return $this;
    }
    /**
     * Get AdExtensionType value
     * @return string[]|null
     */
    public function getAdExtensionType()
    {
        return $this->AdExtensionType;
    }
    /**
     * This method is responsible for validating the values passed to the setAdExtensionType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdExtensionType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdExtensionTypeForArrayConstraintsFromSetAdExtensionType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getAdExtensionsByIdsRequestAdExtensionTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdExtensionsTypeFilter::valueIsValid($getAdExtensionsByIdsRequestAdExtensionTypeItem)) {
                $invalidValues[] = is_object($getAdExtensionsByIdsRequestAdExtensionTypeItem) ? get_class($getAdExtensionsByIdsRequestAdExtensionTypeItem) : sprintf('%s(%s)', gettype($getAdExtensionsByIdsRequestAdExtensionTypeItem), var_export($getAdExtensionsByIdsRequestAdExtensionTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdExtensionsTypeFilter', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdExtensionsTypeFilter::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdExtensionType value
     * @uses \EnumType\AdExtensionsTypeFilter::valueIsValid()
     * @uses \EnumType\AdExtensionsTypeFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $adExtensionType
     * @return \StructType\GetAdExtensionsByIdsRequest
     */
    public function setAdExtensionType(array $adExtensionType = array())
    {
        // validation for constraint: list
        if ('' !== ($adExtensionTypeArrayErrorMessage = self::validateAdExtensionTypeForArrayConstraintsFromSetAdExtensionType($adExtensionType))) {
            throw new \InvalidArgumentException($adExtensionTypeArrayErrorMessage, __LINE__);
        }
        $this->AdExtensionType = is_array($adExtensionType) ? implode(' ', $adExtensionType) : null;
        return $this;
    }
    /**
     * Get ReturnAdditionalFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getReturnAdditionalFields()
    {
        return isset($this->ReturnAdditionalFields) ? $this->ReturnAdditionalFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnAdditionalFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnAdditionalFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getAdExtensionsByIdsRequestReturnAdditionalFieldsItem) {
            // validation for constraint: enumeration
            if (!\EnumType\AdExtensionAdditionalField::valueIsValid($getAdExtensionsByIdsRequestReturnAdditionalFieldsItem)) {
                $invalidValues[] = is_object($getAdExtensionsByIdsRequestReturnAdditionalFieldsItem) ? get_class($getAdExtensionsByIdsRequestReturnAdditionalFieldsItem) : sprintf('%s(%s)', gettype($getAdExtensionsByIdsRequestReturnAdditionalFieldsItem), var_export($getAdExtensionsByIdsRequestReturnAdditionalFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdExtensionAdditionalField', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\AdExtensionAdditionalField::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnAdditionalFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AdExtensionAdditionalField::valueIsValid()
     * @uses \EnumType\AdExtensionAdditionalField::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $returnAdditionalFields
     * @return \StructType\GetAdExtensionsByIdsRequest
     */
    public function setReturnAdditionalFields(array $returnAdditionalFields = array())
    {
        // validation for constraint: list
        if ('' !== ($returnAdditionalFieldsArrayErrorMessage = self::validateReturnAdditionalFieldsForArrayConstraintsFromSetReturnAdditionalFields($returnAdditionalFields))) {
            throw new \InvalidArgumentException($returnAdditionalFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($returnAdditionalFields) || (is_array($returnAdditionalFields) && empty($returnAdditionalFields))) {
            unset($this->ReturnAdditionalFields);
        } else {
            $this->ReturnAdditionalFields = is_array($returnAdditionalFields) ? implode(' ', $returnAdditionalFields) : null;
        }
        return $this;
    }
}
