<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountMigrationStatusesRequest StructType
 * @subpackage Structs
 */
class GetAccountMigrationStatusesRequest extends AbstractStructBase
{
    /**
     * The AccountIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AccountIds;
    /**
     * The MigrationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MigrationType;
    /**
     * Constructor method for GetAccountMigrationStatusesRequest
     * @uses GetAccountMigrationStatusesRequest::setAccountIds()
     * @uses GetAccountMigrationStatusesRequest::setMigrationType()
     * @param \ArrayType\ArrayOflong $accountIds
     * @param string $migrationType
     */
    public function __construct(\ArrayType\ArrayOflong $accountIds = null, $migrationType = null)
    {
        $this
            ->setAccountIds($accountIds)
            ->setMigrationType($migrationType);
    }
    /**
     * Get AccountIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAccountIds()
    {
        return isset($this->AccountIds) ? $this->AccountIds : null;
    }
    /**
     * Set AccountIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $accountIds
     * @return \StructType\GetAccountMigrationStatusesRequest
     */
    public function setAccountIds(\ArrayType\ArrayOflong $accountIds = null)
    {
        if (is_null($accountIds) || (is_array($accountIds) && empty($accountIds))) {
            unset($this->AccountIds);
        } else {
            $this->AccountIds = $accountIds;
        }
        return $this;
    }
    /**
     * Get MigrationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMigrationType()
    {
        return isset($this->MigrationType) ? $this->MigrationType : null;
    }
    /**
     * Set MigrationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $migrationType
     * @return \StructType\GetAccountMigrationStatusesRequest
     */
    public function setMigrationType($migrationType = null)
    {
        // validation for constraint: string
        if (!is_null($migrationType) && !is_string($migrationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($migrationType, true), gettype($migrationType)), __LINE__);
        }
        if (is_null($migrationType) || (is_array($migrationType) && empty($migrationType))) {
            unset($this->MigrationType);
        } else {
            $this->MigrationType = $migrationType;
        }
        return $this;
    }
}
