<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Frequency StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Frequency
 * @subpackage Structs
 */
class Frequency extends AbstractStructBase
{
    /**
     * The Cron
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cron;
    /**
     * The TimeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZone;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Frequency
     * @uses Frequency::setCron()
     * @uses Frequency::setTimeZone()
     * @uses Frequency::setType()
     * @param string $cron
     * @param string $timeZone
     * @param string $type
     */
    public function __construct($cron = null, $timeZone = null, $type = null)
    {
        $this
            ->setCron($cron)
            ->setTimeZone($timeZone)
            ->setType($type);
    }
    /**
     * Get Cron value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCron()
    {
        return isset($this->Cron) ? $this->Cron : null;
    }
    /**
     * Set Cron value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cron
     * @return \StructType\Frequency
     */
    public function setCron($cron = null)
    {
        // validation for constraint: string
        if (!is_null($cron) && !is_string($cron)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cron, true), gettype($cron)), __LINE__);
        }
        if (is_null($cron) || (is_array($cron) && empty($cron))) {
            unset($this->Cron);
        } else {
            $this->Cron = $cron;
        }
        return $this;
    }
    /**
     * Get TimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZone()
    {
        return isset($this->TimeZone) ? $this->TimeZone : null;
    }
    /**
     * Set TimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZone
     * @return \StructType\Frequency
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZone, true), gettype($timeZone)), __LINE__);
        }
        if (is_null($timeZone) || (is_array($timeZone) && empty($timeZone))) {
            unset($this->TimeZone);
        } else {
            $this->TimeZone = $timeZone;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \StructType\Frequency
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
