<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileImportJob StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FileImportJob
 * @subpackage Structs
 */
class FileImportJob extends ImportJob
{
    /**
     * The FileSource
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FileSource;
    /**
     * The FileUrl
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FileUrl;
    /**
     * Constructor method for FileImportJob
     * @uses FileImportJob::setFileSource()
     * @uses FileImportJob::setFileUrl()
     * @param string $fileSource
     * @param string $fileUrl
     */
    public function __construct($fileSource = null, $fileUrl = null)
    {
        $this
            ->setFileSource($fileSource)
            ->setFileUrl($fileUrl);
    }
    /**
     * Get FileSource value
     * @return string|null
     */
    public function getFileSource()
    {
        return $this->FileSource;
    }
    /**
     * Set FileSource value
     * @param string $fileSource
     * @return \StructType\FileImportJob
     */
    public function setFileSource($fileSource = null)
    {
        // validation for constraint: string
        if (!is_null($fileSource) && !is_string($fileSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileSource, true), gettype($fileSource)), __LINE__);
        }
        $this->FileSource = $fileSource;
        return $this;
    }
    /**
     * Get FileUrl value
     * @return string|null
     */
    public function getFileUrl()
    {
        return $this->FileUrl;
    }
    /**
     * Set FileUrl value
     * @param string $fileUrl
     * @return \StructType\FileImportJob
     */
    public function setFileUrl($fileUrl = null)
    {
        // validation for constraint: string
        if (!is_null($fileUrl) && !is_string($fileUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileUrl, true), gettype($fileUrl)), __LINE__);
        }
        $this->FileUrl = $fileUrl;
        return $this;
    }
}
