<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventGoal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventGoal
 * @subpackage Structs
 */
class EventGoal extends ConversionGoal
{
    /**
     * The ActionExpression
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionExpression;
    /**
     * The ActionOperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionOperator;
    /**
     * The CategoryExpression
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CategoryExpression;
    /**
     * The CategoryOperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CategoryOperator;
    /**
     * The LabelExpression
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LabelExpression;
    /**
     * The LabelOperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LabelOperator;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The ValueOperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValueOperator;
    /**
     * Constructor method for EventGoal
     * @uses EventGoal::setActionExpression()
     * @uses EventGoal::setActionOperator()
     * @uses EventGoal::setCategoryExpression()
     * @uses EventGoal::setCategoryOperator()
     * @uses EventGoal::setLabelExpression()
     * @uses EventGoal::setLabelOperator()
     * @uses EventGoal::setValue()
     * @uses EventGoal::setValueOperator()
     * @param string $actionExpression
     * @param string $actionOperator
     * @param string $categoryExpression
     * @param string $categoryOperator
     * @param string $labelExpression
     * @param string $labelOperator
     * @param float $value
     * @param string $valueOperator
     */
    public function __construct($actionExpression = null, $actionOperator = null, $categoryExpression = null, $categoryOperator = null, $labelExpression = null, $labelOperator = null, $value = null, $valueOperator = null)
    {
        $this
            ->setActionExpression($actionExpression)
            ->setActionOperator($actionOperator)
            ->setCategoryExpression($categoryExpression)
            ->setCategoryOperator($categoryOperator)
            ->setLabelExpression($labelExpression)
            ->setLabelOperator($labelOperator)
            ->setValue($value)
            ->setValueOperator($valueOperator);
    }
    /**
     * Get ActionExpression value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionExpression()
    {
        return isset($this->ActionExpression) ? $this->ActionExpression : null;
    }
    /**
     * Set ActionExpression value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionExpression
     * @return \StructType\EventGoal
     */
    public function setActionExpression($actionExpression = null)
    {
        // validation for constraint: string
        if (!is_null($actionExpression) && !is_string($actionExpression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionExpression, true), gettype($actionExpression)), __LINE__);
        }
        if (is_null($actionExpression) || (is_array($actionExpression) && empty($actionExpression))) {
            unset($this->ActionExpression);
        } else {
            $this->ActionExpression = $actionExpression;
        }
        return $this;
    }
    /**
     * Get ActionOperator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionOperator()
    {
        return isset($this->ActionOperator) ? $this->ActionOperator : null;
    }
    /**
     * Set ActionOperator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ExpressionOperator::valueIsValid()
     * @uses \EnumType\ExpressionOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionOperator
     * @return \StructType\EventGoal
     */
    public function setActionOperator($actionOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ExpressionOperator::valueIsValid($actionOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ExpressionOperator', is_array($actionOperator) ? implode(', ', $actionOperator) : var_export($actionOperator, true), implode(', ', \EnumType\ExpressionOperator::getValidValues())), __LINE__);
        }
        if (is_null($actionOperator) || (is_array($actionOperator) && empty($actionOperator))) {
            unset($this->ActionOperator);
        } else {
            $this->ActionOperator = $actionOperator;
        }
        return $this;
    }
    /**
     * Get CategoryExpression value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryExpression()
    {
        return isset($this->CategoryExpression) ? $this->CategoryExpression : null;
    }
    /**
     * Set CategoryExpression value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryExpression
     * @return \StructType\EventGoal
     */
    public function setCategoryExpression($categoryExpression = null)
    {
        // validation for constraint: string
        if (!is_null($categoryExpression) && !is_string($categoryExpression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryExpression, true), gettype($categoryExpression)), __LINE__);
        }
        if (is_null($categoryExpression) || (is_array($categoryExpression) && empty($categoryExpression))) {
            unset($this->CategoryExpression);
        } else {
            $this->CategoryExpression = $categoryExpression;
        }
        return $this;
    }
    /**
     * Get CategoryOperator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryOperator()
    {
        return isset($this->CategoryOperator) ? $this->CategoryOperator : null;
    }
    /**
     * Set CategoryOperator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ExpressionOperator::valueIsValid()
     * @uses \EnumType\ExpressionOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categoryOperator
     * @return \StructType\EventGoal
     */
    public function setCategoryOperator($categoryOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ExpressionOperator::valueIsValid($categoryOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ExpressionOperator', is_array($categoryOperator) ? implode(', ', $categoryOperator) : var_export($categoryOperator, true), implode(', ', \EnumType\ExpressionOperator::getValidValues())), __LINE__);
        }
        if (is_null($categoryOperator) || (is_array($categoryOperator) && empty($categoryOperator))) {
            unset($this->CategoryOperator);
        } else {
            $this->CategoryOperator = $categoryOperator;
        }
        return $this;
    }
    /**
     * Get LabelExpression value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabelExpression()
    {
        return isset($this->LabelExpression) ? $this->LabelExpression : null;
    }
    /**
     * Set LabelExpression value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $labelExpression
     * @return \StructType\EventGoal
     */
    public function setLabelExpression($labelExpression = null)
    {
        // validation for constraint: string
        if (!is_null($labelExpression) && !is_string($labelExpression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelExpression, true), gettype($labelExpression)), __LINE__);
        }
        if (is_null($labelExpression) || (is_array($labelExpression) && empty($labelExpression))) {
            unset($this->LabelExpression);
        } else {
            $this->LabelExpression = $labelExpression;
        }
        return $this;
    }
    /**
     * Get LabelOperator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabelOperator()
    {
        return isset($this->LabelOperator) ? $this->LabelOperator : null;
    }
    /**
     * Set LabelOperator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ExpressionOperator::valueIsValid()
     * @uses \EnumType\ExpressionOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelOperator
     * @return \StructType\EventGoal
     */
    public function setLabelOperator($labelOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ExpressionOperator::valueIsValid($labelOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ExpressionOperator', is_array($labelOperator) ? implode(', ', $labelOperator) : var_export($labelOperator, true), implode(', ', \EnumType\ExpressionOperator::getValidValues())), __LINE__);
        }
        if (is_null($labelOperator) || (is_array($labelOperator) && empty($labelOperator))) {
            unset($this->LabelOperator);
        } else {
            $this->LabelOperator = $labelOperator;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $value
     * @return \StructType\EventGoal
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Get ValueOperator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueOperator()
    {
        return isset($this->ValueOperator) ? $this->ValueOperator : null;
    }
    /**
     * Set ValueOperator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\ValueOperator::valueIsValid()
     * @uses \EnumType\ValueOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueOperator
     * @return \StructType\EventGoal
     */
    public function setValueOperator($valueOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ValueOperator::valueIsValid($valueOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ValueOperator', is_array($valueOperator) ? implode(', ', $valueOperator) : var_export($valueOperator, true), implode(', ', \EnumType\ValueOperator::getValidValues())), __LINE__);
        }
        if (is_null($valueOperator) || (is_array($valueOperator) && empty($valueOperator))) {
            unset($this->ValueOperator);
        } else {
            $this->ValueOperator = $valueOperator;
        }
        return $this;
    }
}
