<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityNegativeKeyword StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntityNegativeKeyword
 * @subpackage Structs
 */
class EntityNegativeKeyword extends AbstractStructBase
{
    /**
     * The EntityId
     * @var int
     */
    public $EntityId;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityType;
    /**
     * The NegativeKeywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNegativeKeyword
     */
    public $NegativeKeywords;
    /**
     * Constructor method for EntityNegativeKeyword
     * @uses EntityNegativeKeyword::setEntityId()
     * @uses EntityNegativeKeyword::setEntityType()
     * @uses EntityNegativeKeyword::setNegativeKeywords()
     * @param int $entityId
     * @param string $entityType
     * @param \ArrayType\ArrayOfNegativeKeyword $negativeKeywords
     */
    public function __construct($entityId = null, $entityType = null, \ArrayType\ArrayOfNegativeKeyword $negativeKeywords = null)
    {
        $this
            ->setEntityId($entityId)
            ->setEntityType($entityType)
            ->setNegativeKeywords($negativeKeywords);
    }
    /**
     * Get EntityId value
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param int $entityId
     * @return \StructType\EntityNegativeKeyword
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \StructType\EntityNegativeKeyword
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
    /**
     * Get NegativeKeywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNegativeKeyword|null
     */
    public function getNegativeKeywords()
    {
        return isset($this->NegativeKeywords) ? $this->NegativeKeywords : null;
    }
    /**
     * Set NegativeKeywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNegativeKeyword $negativeKeywords
     * @return \StructType\EntityNegativeKeyword
     */
    public function setNegativeKeywords(\ArrayType\ArrayOfNegativeKeyword $negativeKeywords = null)
    {
        if (is_null($negativeKeywords) || (is_array($negativeKeywords) && empty($negativeKeywords))) {
            unset($this->NegativeKeywords);
        } else {
            $this->NegativeKeywords = $negativeKeywords;
        }
        return $this;
    }
}
