<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditorialReasonCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EditorialReasonCollection
 * @subpackage Structs
 */
class EditorialReasonCollection extends AbstractStructBase
{
    /**
     * The AdGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdGroupId;
    /**
     * The AdOrKeywordId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdOrKeywordId;
    /**
     * The AppealStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AppealStatus;
    /**
     * The Reasons
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEditorialReason
     */
    public $Reasons;
    /**
     * Constructor method for EditorialReasonCollection
     * @uses EditorialReasonCollection::setAdGroupId()
     * @uses EditorialReasonCollection::setAdOrKeywordId()
     * @uses EditorialReasonCollection::setAppealStatus()
     * @uses EditorialReasonCollection::setReasons()
     * @param int $adGroupId
     * @param int $adOrKeywordId
     * @param string $appealStatus
     * @param \ArrayType\ArrayOfEditorialReason $reasons
     */
    public function __construct($adGroupId = null, $adOrKeywordId = null, $appealStatus = null, \ArrayType\ArrayOfEditorialReason $reasons = null)
    {
        $this
            ->setAdGroupId($adGroupId)
            ->setAdOrKeywordId($adOrKeywordId)
            ->setAppealStatus($appealStatus)
            ->setReasons($reasons);
    }
    /**
     * Get AdGroupId value
     * @return int|null
     */
    public function getAdGroupId()
    {
        return $this->AdGroupId;
    }
    /**
     * Set AdGroupId value
     * @param int $adGroupId
     * @return \StructType\EditorialReasonCollection
     */
    public function setAdGroupId($adGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($adGroupId) && !(is_int($adGroupId) || ctype_digit($adGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adGroupId, true), gettype($adGroupId)), __LINE__);
        }
        $this->AdGroupId = $adGroupId;
        return $this;
    }
    /**
     * Get AdOrKeywordId value
     * @return int|null
     */
    public function getAdOrKeywordId()
    {
        return $this->AdOrKeywordId;
    }
    /**
     * Set AdOrKeywordId value
     * @param int $adOrKeywordId
     * @return \StructType\EditorialReasonCollection
     */
    public function setAdOrKeywordId($adOrKeywordId = null)
    {
        // validation for constraint: int
        if (!is_null($adOrKeywordId) && !(is_int($adOrKeywordId) || ctype_digit($adOrKeywordId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adOrKeywordId, true), gettype($adOrKeywordId)), __LINE__);
        }
        $this->AdOrKeywordId = $adOrKeywordId;
        return $this;
    }
    /**
     * Get AppealStatus value
     * @return string|null
     */
    public function getAppealStatus()
    {
        return $this->AppealStatus;
    }
    /**
     * Set AppealStatus value
     * @uses \EnumType\AppealStatus::valueIsValid()
     * @uses \EnumType\AppealStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appealStatus
     * @return \StructType\EditorialReasonCollection
     */
    public function setAppealStatus($appealStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AppealStatus::valueIsValid($appealStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AppealStatus', is_array($appealStatus) ? implode(', ', $appealStatus) : var_export($appealStatus, true), implode(', ', \EnumType\AppealStatus::getValidValues())), __LINE__);
        }
        $this->AppealStatus = $appealStatus;
        return $this;
    }
    /**
     * Get Reasons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEditorialReason|null
     */
    public function getReasons()
    {
        return isset($this->Reasons) ? $this->Reasons : null;
    }
    /**
     * Set Reasons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEditorialReason $reasons
     * @return \StructType\EditorialReasonCollection
     */
    public function setReasons(\ArrayType\ArrayOfEditorialReason $reasons = null)
    {
        if (is_null($reasons) || (is_array($reasons) && empty($reasons))) {
            unset($this->Reasons);
        } else {
            $this->Reasons = $reasons;
        }
        return $this;
    }
}
