<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditorialReason StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EditorialReason
 * @subpackage Structs
 */
class EditorialReason extends AbstractStructBase
{
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Location;
    /**
     * The PublisherCountries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $PublisherCountries;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReasonCode;
    /**
     * The Term
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Term;
    /**
     * Constructor method for EditorialReason
     * @uses EditorialReason::setLocation()
     * @uses EditorialReason::setPublisherCountries()
     * @uses EditorialReason::setReasonCode()
     * @uses EditorialReason::setTerm()
     * @param string $location
     * @param \ArrayType\ArrayOfstring $publisherCountries
     * @param int $reasonCode
     * @param string $term
     */
    public function __construct($location = null, \ArrayType\ArrayOfstring $publisherCountries = null, $reasonCode = null, $term = null)
    {
        $this
            ->setLocation($location)
            ->setPublisherCountries($publisherCountries)
            ->setReasonCode($reasonCode)
            ->setTerm($term);
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $location
     * @return \StructType\EditorialReason
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get PublisherCountries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getPublisherCountries()
    {
        return isset($this->PublisherCountries) ? $this->PublisherCountries : null;
    }
    /**
     * Set PublisherCountries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $publisherCountries
     * @return \StructType\EditorialReason
     */
    public function setPublisherCountries(\ArrayType\ArrayOfstring $publisherCountries = null)
    {
        if (is_null($publisherCountries) || (is_array($publisherCountries) && empty($publisherCountries))) {
            unset($this->PublisherCountries);
        } else {
            $this->PublisherCountries = $publisherCountries;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return int|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param int $reasonCode
     * @return \StructType\EditorialReason
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: int
        if (!is_null($reasonCode) && !(is_int($reasonCode) || ctype_digit($reasonCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get Term value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTerm()
    {
        return isset($this->Term) ? $this->Term : null;
    }
    /**
     * Set Term value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $term
     * @return \StructType\EditorialReason
     */
    public function setTerm($term = null)
    {
        // validation for constraint: string
        if (!is_null($term) && !is_string($term)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($term, true), gettype($term)), __LINE__);
        }
        if (is_null($term) || (is_array($term) && empty($term))) {
            unset($this->Term);
        } else {
            $this->Term = $term;
        }
        return $this;
    }
}
