<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditorialErrorCollection StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EditorialErrorCollection
 * @subpackage Structs
 */
class EditorialErrorCollection extends BatchErrorCollection
{
    /**
     * The Appealable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Appealable;
    /**
     * The DisapprovedText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisapprovedText;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Location;
    /**
     * The PublisherCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PublisherCountry;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReasonCode;
    /**
     * Constructor method for EditorialErrorCollection
     * @uses EditorialErrorCollection::setAppealable()
     * @uses EditorialErrorCollection::setDisapprovedText()
     * @uses EditorialErrorCollection::setLocation()
     * @uses EditorialErrorCollection::setPublisherCountry()
     * @uses EditorialErrorCollection::setReasonCode()
     * @param bool $appealable
     * @param string $disapprovedText
     * @param string $location
     * @param string $publisherCountry
     * @param int $reasonCode
     */
    public function __construct($appealable = null, $disapprovedText = null, $location = null, $publisherCountry = null, $reasonCode = null)
    {
        $this
            ->setAppealable($appealable)
            ->setDisapprovedText($disapprovedText)
            ->setLocation($location)
            ->setPublisherCountry($publisherCountry)
            ->setReasonCode($reasonCode);
    }
    /**
     * Get Appealable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAppealable()
    {
        return isset($this->Appealable) ? $this->Appealable : null;
    }
    /**
     * Set Appealable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $appealable
     * @return \StructType\EditorialErrorCollection
     */
    public function setAppealable($appealable = null)
    {
        // validation for constraint: boolean
        if (!is_null($appealable) && !is_bool($appealable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($appealable, true), gettype($appealable)), __LINE__);
        }
        if (is_null($appealable) || (is_array($appealable) && empty($appealable))) {
            unset($this->Appealable);
        } else {
            $this->Appealable = $appealable;
        }
        return $this;
    }
    /**
     * Get DisapprovedText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisapprovedText()
    {
        return isset($this->DisapprovedText) ? $this->DisapprovedText : null;
    }
    /**
     * Set DisapprovedText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $disapprovedText
     * @return \StructType\EditorialErrorCollection
     */
    public function setDisapprovedText($disapprovedText = null)
    {
        // validation for constraint: string
        if (!is_null($disapprovedText) && !is_string($disapprovedText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disapprovedText, true), gettype($disapprovedText)), __LINE__);
        }
        if (is_null($disapprovedText) || (is_array($disapprovedText) && empty($disapprovedText))) {
            unset($this->DisapprovedText);
        } else {
            $this->DisapprovedText = $disapprovedText;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $location
     * @return \StructType\EditorialErrorCollection
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get PublisherCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublisherCountry()
    {
        return isset($this->PublisherCountry) ? $this->PublisherCountry : null;
    }
    /**
     * Set PublisherCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publisherCountry
     * @return \StructType\EditorialErrorCollection
     */
    public function setPublisherCountry($publisherCountry = null)
    {
        // validation for constraint: string
        if (!is_null($publisherCountry) && !is_string($publisherCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publisherCountry, true), gettype($publisherCountry)), __LINE__);
        }
        if (is_null($publisherCountry) || (is_array($publisherCountry) && empty($publisherCountry))) {
            unset($this->PublisherCountry);
        } else {
            $this->PublisherCountry = $publisherCountry;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return int|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param int $reasonCode
     * @return \StructType\EditorialErrorCollection
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: int
        if (!is_null($reasonCode) && !(is_int($reasonCode) || ctype_digit($reasonCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
}
