<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DynamicSearchAdsSetting StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DynamicSearchAdsSetting
 * @subpackage Structs
 */
class DynamicSearchAdsSetting extends Setting
{
    /**
     * The DomainName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomainName;
    /**
     * The DynamicDescriptionEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DynamicDescriptionEnabled;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Language;
    /**
     * The PageFeedIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $PageFeedIds;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Source;
    /**
     * Constructor method for DynamicSearchAdsSetting
     * @uses DynamicSearchAdsSetting::setDomainName()
     * @uses DynamicSearchAdsSetting::setDynamicDescriptionEnabled()
     * @uses DynamicSearchAdsSetting::setLanguage()
     * @uses DynamicSearchAdsSetting::setPageFeedIds()
     * @uses DynamicSearchAdsSetting::setSource()
     * @param string $domainName
     * @param bool $dynamicDescriptionEnabled
     * @param string $language
     * @param \ArrayType\ArrayOflong $pageFeedIds
     * @param string $source
     */
    public function __construct($domainName = null, $dynamicDescriptionEnabled = null, $language = null, \ArrayType\ArrayOflong $pageFeedIds = null, $source = null)
    {
        $this
            ->setDomainName($domainName)
            ->setDynamicDescriptionEnabled($dynamicDescriptionEnabled)
            ->setLanguage($language)
            ->setPageFeedIds($pageFeedIds)
            ->setSource($source);
    }
    /**
     * Get DomainName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomainName()
    {
        return isset($this->DomainName) ? $this->DomainName : null;
    }
    /**
     * Set DomainName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domainName
     * @return \StructType\DynamicSearchAdsSetting
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainName, true), gettype($domainName)), __LINE__);
        }
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->DomainName);
        } else {
            $this->DomainName = $domainName;
        }
        return $this;
    }
    /**
     * Get DynamicDescriptionEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDynamicDescriptionEnabled()
    {
        return isset($this->DynamicDescriptionEnabled) ? $this->DynamicDescriptionEnabled : null;
    }
    /**
     * Set DynamicDescriptionEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $dynamicDescriptionEnabled
     * @return \StructType\DynamicSearchAdsSetting
     */
    public function setDynamicDescriptionEnabled($dynamicDescriptionEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($dynamicDescriptionEnabled) && !is_bool($dynamicDescriptionEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dynamicDescriptionEnabled, true), gettype($dynamicDescriptionEnabled)), __LINE__);
        }
        if (is_null($dynamicDescriptionEnabled) || (is_array($dynamicDescriptionEnabled) && empty($dynamicDescriptionEnabled))) {
            unset($this->DynamicDescriptionEnabled);
        } else {
            $this->DynamicDescriptionEnabled = $dynamicDescriptionEnabled;
        }
        return $this;
    }
    /**
     * Get Language value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguage()
    {
        return isset($this->Language) ? $this->Language : null;
    }
    /**
     * Set Language value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $language
     * @return \StructType\DynamicSearchAdsSetting
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        if (is_null($language) || (is_array($language) && empty($language))) {
            unset($this->Language);
        } else {
            $this->Language = $language;
        }
        return $this;
    }
    /**
     * Get PageFeedIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getPageFeedIds()
    {
        return isset($this->PageFeedIds) ? $this->PageFeedIds : null;
    }
    /**
     * Set PageFeedIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $pageFeedIds
     * @return \StructType\DynamicSearchAdsSetting
     */
    public function setPageFeedIds(\ArrayType\ArrayOflong $pageFeedIds = null)
    {
        if (is_null($pageFeedIds) || (is_array($pageFeedIds) && empty($pageFeedIds))) {
            unset($this->PageFeedIds);
        } else {
            $this->PageFeedIds = $pageFeedIds;
        }
        return $this;
    }
    /**
     * Get Source value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSource()
    {
        return isset($this->Source) ? $this->Source : null;
    }
    /**
     * Set Source value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\DynamicSearchAdsSource::valueIsValid()
     * @uses \EnumType\DynamicSearchAdsSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $source
     * @return \StructType\DynamicSearchAdsSetting
     */
    public function setSource($source = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DynamicSearchAdsSource::valueIsValid($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DynamicSearchAdsSource', is_array($source) ? implode(', ', $source) : var_export($source, true), implode(', ', \EnumType\DynamicSearchAdsSource::getValidValues())), __LINE__);
        }
        if (is_null($source) || (is_array($source) && empty($source))) {
            unset($this->Source);
        } else {
            $this->Source = $source;
        }
        return $this;
    }
}
