<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DurationGoal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DurationGoal
 * @subpackage Structs
 */
class DurationGoal extends ConversionGoal
{
    /**
     * The MinimumDurationInSeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinimumDurationInSeconds;
    /**
     * Constructor method for DurationGoal
     * @uses DurationGoal::setMinimumDurationInSeconds()
     * @param int $minimumDurationInSeconds
     */
    public function __construct($minimumDurationInSeconds = null)
    {
        $this
            ->setMinimumDurationInSeconds($minimumDurationInSeconds);
    }
    /**
     * Get MinimumDurationInSeconds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinimumDurationInSeconds()
    {
        return isset($this->MinimumDurationInSeconds) ? $this->MinimumDurationInSeconds : null;
    }
    /**
     * Set MinimumDurationInSeconds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minimumDurationInSeconds
     * @return \StructType\DurationGoal
     */
    public function setMinimumDurationInSeconds($minimumDurationInSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($minimumDurationInSeconds) && !(is_int($minimumDurationInSeconds) || ctype_digit($minimumDurationInSeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumDurationInSeconds, true), gettype($minimumDurationInSeconds)), __LINE__);
        }
        if (is_null($minimumDurationInSeconds) || (is_array($minimumDurationInSeconds) && empty($minimumDurationInSeconds))) {
            unset($this->MinimumDurationInSeconds);
        } else {
            $this->MinimumDurationInSeconds = $minimumDurationInSeconds;
        }
        return $this;
    }
}
