<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteSharedEntitiesRequest StructType
 * @subpackage Structs
 */
class DeleteSharedEntitiesRequest extends AbstractStructBase
{
    /**
     * The SharedEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSharedEntity
     */
    public $SharedEntities;
    /**
     * The SharedEntityScope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SharedEntityScope;
    /**
     * Constructor method for DeleteSharedEntitiesRequest
     * @uses DeleteSharedEntitiesRequest::setSharedEntities()
     * @uses DeleteSharedEntitiesRequest::setSharedEntityScope()
     * @param \ArrayType\ArrayOfSharedEntity $sharedEntities
     * @param string $sharedEntityScope
     */
    public function __construct(\ArrayType\ArrayOfSharedEntity $sharedEntities = null, $sharedEntityScope = null)
    {
        $this
            ->setSharedEntities($sharedEntities)
            ->setSharedEntityScope($sharedEntityScope);
    }
    /**
     * Get SharedEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSharedEntity|null
     */
    public function getSharedEntities()
    {
        return isset($this->SharedEntities) ? $this->SharedEntities : null;
    }
    /**
     * Set SharedEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSharedEntity $sharedEntities
     * @return \StructType\DeleteSharedEntitiesRequest
     */
    public function setSharedEntities(\ArrayType\ArrayOfSharedEntity $sharedEntities = null)
    {
        if (is_null($sharedEntities) || (is_array($sharedEntities) && empty($sharedEntities))) {
            unset($this->SharedEntities);
        } else {
            $this->SharedEntities = $sharedEntities;
        }
        return $this;
    }
    /**
     * Get SharedEntityScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedEntityScope()
    {
        return isset($this->SharedEntityScope) ? $this->SharedEntityScope : null;
    }
    /**
     * Set SharedEntityScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EntityScope::valueIsValid()
     * @uses \EnumType\EntityScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sharedEntityScope
     * @return \StructType\DeleteSharedEntitiesRequest
     */
    public function setSharedEntityScope($sharedEntityScope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityScope::valueIsValid($sharedEntityScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityScope', is_array($sharedEntityScope) ? implode(', ', $sharedEntityScope) : var_export($sharedEntityScope, true), implode(', ', \EnumType\EntityScope::getValidValues())), __LINE__);
        }
        if (is_null($sharedEntityScope) || (is_array($sharedEntityScope) && empty($sharedEntityScope))) {
            unset($this->SharedEntityScope);
        } else {
            $this->SharedEntityScope = $sharedEntityScope;
        }
        return $this;
    }
}
