<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteMediaRequest StructType
 * @subpackage Structs
 */
class DeleteMediaRequest extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountId;
    /**
     * The MediaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $MediaIds;
    /**
     * Constructor method for DeleteMediaRequest
     * @uses DeleteMediaRequest::setAccountId()
     * @uses DeleteMediaRequest::setMediaIds()
     * @param int $accountId
     * @param \ArrayType\ArrayOflong $mediaIds
     */
    public function __construct($accountId = null, \ArrayType\ArrayOflong $mediaIds = null)
    {
        $this
            ->setAccountId($accountId)
            ->setMediaIds($mediaIds);
    }
    /**
     * Get AccountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param int $accountId
     * @return \StructType\DeleteMediaRequest
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !(is_int($accountId) || ctype_digit($accountId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get MediaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getMediaIds()
    {
        return isset($this->MediaIds) ? $this->MediaIds : null;
    }
    /**
     * Set MediaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $mediaIds
     * @return \StructType\DeleteMediaRequest
     */
    public function setMediaIds(\ArrayType\ArrayOflong $mediaIds = null)
    {
        if (is_null($mediaIds) || (is_array($mediaIds) && empty($mediaIds))) {
            unset($this->MediaIds);
        } else {
            $this->MediaIds = $mediaIds;
        }
        return $this;
    }
}
