<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteLabelsRequest StructType
 * @subpackage Structs
 */
class DeleteLabelsRequest extends AbstractStructBase
{
    /**
     * The LabelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $LabelIds;
    /**
     * Constructor method for DeleteLabelsRequest
     * @uses DeleteLabelsRequest::setLabelIds()
     * @param \ArrayType\ArrayOflong $labelIds
     */
    public function __construct(\ArrayType\ArrayOflong $labelIds = null)
    {
        $this
            ->setLabelIds($labelIds);
    }
    /**
     * Get LabelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getLabelIds()
    {
        return isset($this->LabelIds) ? $this->LabelIds : null;
    }
    /**
     * Set LabelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $labelIds
     * @return \StructType\DeleteLabelsRequest
     */
    public function setLabelIds(\ArrayType\ArrayOflong $labelIds = null)
    {
        if (is_null($labelIds) || (is_array($labelIds) && empty($labelIds))) {
            unset($this->LabelIds);
        } else {
            $this->LabelIds = $labelIds;
        }
        return $this;
    }
}
