<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteImportJobsRequest StructType
 * @subpackage Structs
 */
class DeleteImportJobsRequest extends AbstractStructBase
{
    /**
     * The ImportJobIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $ImportJobIds;
    /**
     * The ImportType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportType;
    /**
     * Constructor method for DeleteImportJobsRequest
     * @uses DeleteImportJobsRequest::setImportJobIds()
     * @uses DeleteImportJobsRequest::setImportType()
     * @param \ArrayType\ArrayOflong $importJobIds
     * @param string $importType
     */
    public function __construct(\ArrayType\ArrayOflong $importJobIds = null, $importType = null)
    {
        $this
            ->setImportJobIds($importJobIds)
            ->setImportType($importType);
    }
    /**
     * Get ImportJobIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getImportJobIds()
    {
        return isset($this->ImportJobIds) ? $this->ImportJobIds : null;
    }
    /**
     * Set ImportJobIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $importJobIds
     * @return \StructType\DeleteImportJobsRequest
     */
    public function setImportJobIds(\ArrayType\ArrayOflong $importJobIds = null)
    {
        if (is_null($importJobIds) || (is_array($importJobIds) && empty($importJobIds))) {
            unset($this->ImportJobIds);
        } else {
            $this->ImportJobIds = $importJobIds;
        }
        return $this;
    }
    /**
     * Get ImportType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportType()
    {
        return isset($this->ImportType) ? $this->ImportType : null;
    }
    /**
     * Set ImportType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importType
     * @return \StructType\DeleteImportJobsRequest
     */
    public function setImportType($importType = null)
    {
        // validation for constraint: string
        if (!is_null($importType) && !is_string($importType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importType, true), gettype($importType)), __LINE__);
        }
        if (is_null($importType) || (is_array($importType) && empty($importType))) {
            unset($this->ImportType);
        } else {
            $this->ImportType = $importType;
        }
        return $this;
    }
}
