<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteAdsRequest StructType
 * @subpackage Structs
 */
class DeleteAdsRequest extends AbstractStructBase
{
    /**
     * The AdGroupId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdGroupId;
    /**
     * The AdIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AdIds;
    /**
     * Constructor method for DeleteAdsRequest
     * @uses DeleteAdsRequest::setAdGroupId()
     * @uses DeleteAdsRequest::setAdIds()
     * @param int $adGroupId
     * @param \ArrayType\ArrayOflong $adIds
     */
    public function __construct($adGroupId = null, \ArrayType\ArrayOflong $adIds = null)
    {
        $this
            ->setAdGroupId($adGroupId)
            ->setAdIds($adIds);
    }
    /**
     * Get AdGroupId value
     * @return int|null
     */
    public function getAdGroupId()
    {
        return $this->AdGroupId;
    }
    /**
     * Set AdGroupId value
     * @param int $adGroupId
     * @return \StructType\DeleteAdsRequest
     */
    public function setAdGroupId($adGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($adGroupId) && !(is_int($adGroupId) || ctype_digit($adGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adGroupId, true), gettype($adGroupId)), __LINE__);
        }
        $this->AdGroupId = $adGroupId;
        return $this;
    }
    /**
     * Get AdIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAdIds()
    {
        return isset($this->AdIds) ? $this->AdIds : null;
    }
    /**
     * Set AdIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $adIds
     * @return \StructType\DeleteAdsRequest
     */
    public function setAdIds(\ArrayType\ArrayOflong $adIds = null)
    {
        if (is_null($adIds) || (is_array($adIds) && empty($adIds))) {
            unset($this->AdIds);
        } else {
            $this->AdIds = $adIds;
        }
        return $this;
    }
}
