<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteAdGroupsRequest StructType
 * @subpackage Structs
 */
class DeleteAdGroupsRequest extends AbstractStructBase
{
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CampaignId;
    /**
     * The AdGroupIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOflong
     */
    public $AdGroupIds;
    /**
     * Constructor method for DeleteAdGroupsRequest
     * @uses DeleteAdGroupsRequest::setCampaignId()
     * @uses DeleteAdGroupsRequest::setAdGroupIds()
     * @param int $campaignId
     * @param \ArrayType\ArrayOflong $adGroupIds
     */
    public function __construct($campaignId = null, \ArrayType\ArrayOflong $adGroupIds = null)
    {
        $this
            ->setCampaignId($campaignId)
            ->setAdGroupIds($adGroupIds);
    }
    /**
     * Get CampaignId value
     * @return int|null
     */
    public function getCampaignId()
    {
        return $this->CampaignId;
    }
    /**
     * Set CampaignId value
     * @param int $campaignId
     * @return \StructType\DeleteAdGroupsRequest
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: int
        if (!is_null($campaignId) && !(is_int($campaignId) || ctype_digit($campaignId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        $this->CampaignId = $campaignId;
        return $this;
    }
    /**
     * Get AdGroupIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOflong|null
     */
    public function getAdGroupIds()
    {
        return isset($this->AdGroupIds) ? $this->AdGroupIds : null;
    }
    /**
     * Set AdGroupIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOflong $adGroupIds
     * @return \StructType\DeleteAdGroupsRequest
     */
    public function setAdGroupIds(\ArrayType\ArrayOflong $adGroupIds = null)
    {
        if (is_null($adGroupIds) || (is_array($adGroupIds) && empty($adGroupIds))) {
            unset($this->AdGroupIds);
        } else {
            $this->AdGroupIds = $adGroupIds;
        }
        return $this;
    }
}
